/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNode;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNodeCollection;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaRelationJSONHandler
extends AbstractJSONHandler<MetaRelation, BPMSerializeContext> {
    @Override
    public void fromJSONImpl(MetaRelation meta, JSONObject json) throws Throwable {
        JSONArray array;
        String s = json.optString("relationSource");
        if (s.length() > 0) {
            MetaBaseScript script = new MetaBaseScript("RelationSource");
            script.setContent(s);
            meta.setScript(script);
        }
        if ((array = json.optJSONArray("relationNodeCollection")) != null) {
            MetaRelationNodeCollection nodecollection = new MetaRelationNodeCollection();
            nodecollection.addAll(BPMJSONHandlerUtil.unbuild(MetaRelationNode.class, array));
            meta.setNodecollection(nodecollection);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaRelation meta, BPMSerializeContext hook) throws Throwable {
        MetaRelationNodeCollection nodecollection;
        JSONHelper.writeToJSON((JSONObject)json, (String)"tagName", (Object)meta.getTagName());
        MetaBaseScript script = meta.getScript();
        if (script != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"relationSource", (Object)script.getContent().trim());
        }
        if ((nodecollection = meta.getNodeCollection()) != null) {
            JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)nodecollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"relationNodeCollection", (Object)array);
        }
    }

    @Override
    public MetaRelation newInstance() {
        return new MetaRelation();
    }
}

