package com.bokesoft.yes.meta.json.setting;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;

public class MetaLoginSettingJSONHandler extends AbstractJSONHandler<MetaLoginSetting,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLoginSetting meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_NORMALAPPLOGIN, meta.getNormalAppLogin());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_LOGINPROCESS, meta.getLoginProcess());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_LOGOUTPROCESS, meta.getLogoutProcess());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_SSOPROVIDER, meta.getSSOProvider());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_SESSIONPARA, meta.isSessionPara());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_MULTILANG, meta.isMultiLang());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_ENCRYPTTYPE, meta.getEncryptType());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_CHANGEPWDPROCESS, meta.getChangePwdProcess());
		JSONHelper.writeToJSON(json, JSONConstants.SETTING_OVERTIMEPROCESS, meta.getOvertimeProcess());
	}

	@Override
	public MetaLoginSetting newInstance() {
		return new MetaLoginSetting();
	}

	@Override
	public void fromJSONImpl(MetaLoginSetting meta, JSONObject json) throws Throwable {
		meta.setNormalAppLogin(json.optString(JSONConstants.SETTING_NORMALAPPLOGIN));
		meta.setLoginProcess(json.optString(JSONConstants.SETTING_LOGINPROCESS));
		meta.setLogoutProcess(json.optString(JSONConstants.SETTING_LOGOUTPROCESS));
		meta.setSSOProvider(json.optString(JSONConstants.SETTING_SSOPROVIDER));
		meta.setSessionPara(json.optBoolean(JSONConstants.SETTING_SESSIONPARA));
		meta.setMultiLang(json.optBoolean(JSONConstants.SETTING_MULTILANG));
		meta.setEncryptType(json.optInt(JSONConstants.SETTING_NORMALAPPLOGIN));
		meta.setChangePwdProcess(json.optString(JSONConstants.SETTING_CHANGEPWDPROCESS));
		meta.setOvertimeProcess(json.optString(JSONConstants.SETTING_OVERTIMEPROCESS));
	}

}
