package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.embed.MetaReportImage;

public class MetaReportImageJSONHandler extends AbstractJSONHandler<MetaReportImage,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportImage meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_X, meta.getX());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_Y, meta.getY());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PATH, meta.getPath());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_IMAGESCALETYPE, meta.getImageScaleType());
	}

	@Override
	public MetaReportImage newInstance() {
		return new MetaReportImage();
	}

	@Override
	public void fromJSONImpl(MetaReportImage meta, JSONObject json) throws Throwable {
		meta.setX(json.optInt(JSONConstants.COMPONENT_X));
		meta.setY(json.optInt(JSONConstants.COMPONENT_Y));
		meta.setWidth(json.optInt(JSONConstants.COMMON_WIDTH));
		meta.setHeight(json.optInt(JSONConstants.COMMON_HEIGHT));
		
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setPath(json.optString(JSONConstants.REPORT_PATH));
		meta.setImageScaleType(json.optInt(JSONConstants.REPORT_IMAGESCALETYPE));
	}

}
