package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportCellText;

public class MetaReportCellTextJSONHandler extends AbstractJSONHandler<MetaReportCellText,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportCellText meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CONTENT, meta.getContent());
	}

	@Override
	public MetaReportCellText newInstance() {
		return new MetaReportCellText();
	}

	@Override
	public void fromJSONImpl(MetaReportCellText meta, JSONObject json) throws Throwable {
		meta.setContent(json.optString(JSONConstants.COMMON_CONTENT));
	}

}
