package com.bokesoft.yes.meta.json.panel.gridpanel;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;

public class MetaRowDefCollectionJSONHandler extends AbstractJSONHandler<MetaRowDefCollection,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaRowDefCollection meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_ROWGAP, meta.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_ROWHEIGHT, meta.getRowHeight());
		
		JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		json.put(JSONConstants.COMMON_ITEMS, array);
		
		
		// ---之前的预处理--------------------
		JSONArray rows = new JSONArray();
		for( MetaRowDef rowDef : meta ) {
			DefSize height = rowDef.getHeight();
			if( height != null ) {
				rows.put(height.toString());// DefSize
			} else {
				rows.put(meta.getRowHeight());// int
			}
		}
		
		json.put(JSONConstants.GRIDLAYOUTPANEL_HEIGHTS, rows);
	}

	@Override
	public void fromJSONImpl(MetaRowDefCollection meta, JSONObject json) throws Throwable {
		meta.setRowGap(json.optInt(JSONConstants.GRIDLAYOUTPANEL_ROWGAP));
		meta.setRowHeight(json.optInt(JSONConstants.GRIDLAYOUTPANEL_ROWHEIGHT));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaRowDef> list = UIJSONHandlerUtil.unbuild(MetaRowDef.class, array);
			meta.addAll(0, list);
		}
	}

	@Override
	public MetaRowDefCollection newInstance() {
		return new MetaRowDefCollection();
	}

}
