package com.bokesoft.yes.meta.json.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.panel.MetaLinearLayoutPanel;

public class MetaLinearLayoutPanelJSONHandler extends BasePanelJSONHandler<MetaLinearLayoutPanel> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaLinearLayoutPanel meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.LINEARLAYOUTPANEL_ORIENTATION, meta.getOrientation());
	}
	
	@Override
	public void fromJSONImpl(MetaLinearLayoutPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setOrientation(json.optInt(JSONConstants.LINEARLAYOUTPANEL_ORIENTATION));
	}

	@Override
	public MetaLinearLayoutPanel newInstance() {
		return new MetaLinearLayoutPanel();
	}
}
