package com.bokesoft.yes.meta.json.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.customlayoutpanel.MetaCustomLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;

public class MetaCustomLayoutPanelJSONHandler extends BasePanelJSONHandler<MetaCustomLayoutPanel> {
	
	@Override
	public void fromJSONImpl(MetaCustomLayoutPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		JSONObject layout = json.optJSONObject(JSONConstants.BASEPANEL_LAYOUT);
				
		JSONObject o = layout.optJSONObject(JSONConstants.LAYOUT_ROWCOLLECTION);
		if( o != null ) {
			MetaRowDefCollection rowDefCollection = UIJSONHandlerUtil.unbuild(MetaRowDefCollection.class, o);
			meta.setRowDefCollection(rowDefCollection);
		}
		
		o = layout.optJSONObject(JSONConstants.LAYOUT_COLUMNCOLLECTION);
		if( o != null ) {
			MetaColumnDefCollection columnDefCollection = UIJSONHandlerUtil.unbuild(MetaColumnDefCollection.class, o);
			meta.setColumnDefCollection(columnDefCollection);
		}
	}

	@Override
	public MetaCustomLayoutPanel newInstance() {
		return new MetaCustomLayoutPanel();
	}

}
