package com.bokesoft.yes.meta.json.other;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.solution.MetaStartItem;

public class MetaStartItemJSONHandler extends AbstractJSONHandler<MetaStartItem,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaStartItem meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.STARTITEM_PLATFORM, meta.getPlatform());
		JSONHelper.writeToJSON(json, JSONConstants.STARTITEM_STARTFORM, meta.getStartForm());
		JSONHelper.writeToJSON(json, JSONConstants.STARTITEM_LOGINFORM, meta.getLoginForm());
		JSONHelper.writeToJSON(json, JSONConstants.STARTITEM_APPKEY, meta.getAppKey());	
	}

	@Override
	public MetaStartItem newInstance() {
		return new MetaStartItem();
	}

	@Override
	public void fromJSONImpl(MetaStartItem meta, JSONObject json) throws Throwable {
		meta.setPlatform(json.optString(JSONConstants.STARTITEM_PLATFORM));
		meta.setStartForm(json.optString(JSONConstants.STARTITEM_STARTFORM));
		meta.setLoginForm(json.optString(JSONConstants.STARTITEM_LOGINFORM));
		meta.setAppKey(json.optString(JSONConstants.STARTITEM_APPKEY));
	}

}
