package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;

public class MetaUICheckRuleJSONHandler extends MetaBaseScriptJSONHandler<MetaUICheckRule,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaUICheckRule meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.UICHECKRULE_DESCRIPTION, meta.getDescription());
		String errorInfo = hook.getString(GroupKeyTable.STR_ERROR, "", meta.getStringID(), meta.getErrorInfo());
		JSONHelper.writeToJSON(json, JSONConstants.UICHECKRULE_ERRORINFO, errorInfo);
		JSONHelper.writeToJSON(json, JSONConstants.UICHECKRULE_STRINGID, meta.getStringID());
		JSONHelper.writeToJSON(json, JSONConstants.UICHECKRULE_TARGET, meta.getTarget());
		JSONHelper.writeToJSON(json, JSONConstants.UICHECKRULE_DEPENDENCY, meta.getDependency());
	}
	
	@Override
	public void fromJSONImpl(MetaUICheckRule meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setDescription(json.optString(JSONConstants.UICHECKRULE_DESCRIPTION));
		meta.setErrorInfo(json.optString(JSONConstants.UICHECKRULE_ERRORINFO));
		meta.setStringID(json.optString(JSONConstants.UICHECKRULE_STRINGID));
		meta.setTarget(json.optString(JSONConstants.UICHECKRULE_TARGET));
		meta.setDependency(json.optString(JSONConstants.UICHECKRULE_DEPENDENCY));
	}
	
	@Override
	public MetaUICheckRule newInstance() {
		return new MetaUICheckRule();
	}
}
