package com.bokesoft.yes.meta.json.form;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;

public class MetaTableJSONHandler extends AbstractJSONHandler<MetaTable,ISerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaTable meta, ISerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PARENTKEY, meta.getParentKey());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_DBTABLENAME, meta.getDBTableName());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_TABLEMODE, meta.getTableMode());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_PERSIST, meta.isPersist());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_HIDDEN, meta.isHidden());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_UNIQUE_PRIMARY, meta.isUniquePrimary());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_ORDERBY, meta.getOrderBy());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_FORMULA, meta.getFormula());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_IMPL, meta.getImpl());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_LOAD_IN_MID_USE, meta.isLoadInMidUse());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_LAZY_LOAD, meta.isLazyLoad());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_INDEXPREFIX, meta.getIndexPrefix());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_PRIMARYKEY, meta.getPrimaryKey());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_GROUPBY, meta.getGroupBy());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_USE_CURSOR, meta.isUseCursor());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_REFRESH_FILTER, meta.isRefreshFilter());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_HISTABLENAME, meta.getHisTableName());
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_CONVERTOR, meta.getConvertor());
		
		JSONArray array = UIJSONHandlerUtil.buildKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.TABLE_COLUMNS, array);
				
		MetaParameterCollection parameterCollection = meta.getParameterCollection();
		if( parameterCollection != null ) {
			JSONArray ar = UIJSONHandlerUtil.buildNoKeyCollection(hook, parameterCollection);
			JSONHelper.writeToJSON(json, JSONConstants.TABLE_PARAMETER_COLLECTION, ar);
		}
		
		MetaStatement statement = meta.getStatement();
		if( statement != null ) {
			JSONObject o = UIJSONHandlerUtil.build(statement,hook);
			JSONHelper.writeToJSON(json, JSONConstants.TABLE_STATEMENT, o);
		}
	}

	@Override
	public MetaTable newInstance() {
		return new MetaTable();
	}

	@Override
	public void fromJSONImpl(MetaTable meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setParentKey(json.optString(JSONConstants.COMMON_PARENTKEY));
		meta.setDBTableName(json.optString(JSONConstants.TABLE_DBTABLENAME));
		meta.setTableMode(json.optInt(JSONConstants.TABLE_TABLEMODE));
		meta.setSourceType(json.optInt(JSONConstants.TABLE_SOURCETYPE));
		meta.setPersist(json.optBoolean(JSONConstants.TABLE_PERSIST));
		meta.setHidden(json.optBoolean(JSONConstants.TABLE_HIDDEN));
		meta.setUniquePrimary(json.optBoolean(JSONConstants.TABLE_UNIQUE_PRIMARY));
		meta.setOrderBy(json.optString(JSONConstants.TABLE_ORDERBY));
		meta.setFormula(json.optString(JSONConstants.TABLE_FORMULA));
		meta.setImpl(json.optString(JSONConstants.TABLE_IMPL));
		meta.setLoadInMidUse(json.optBoolean(JSONConstants.TABLE_LOAD_IN_MID_USE));
		meta.setLazyLoad(json.optBoolean(JSONConstants.TABLE_LAZY_LOAD));
		meta.setIndexPrefix(json.optString(JSONConstants.TABLE_INDEXPREFIX));
		meta.setPrimaryKey(json.optString(JSONConstants.TABLE_PRIMARYKEY));
		meta.setGroupBy(json.optString(JSONConstants.TABLE_GROUPBY));
		meta.setUseCursor(json.optBoolean(JSONConstants.TABLE_USE_CURSOR));
		meta.setRefreshFilter(json.optBoolean(JSONConstants.TABLE_REFRESH_FILTER));
		meta.setHisTableName(json.optString(JSONConstants.TABLE_HISTABLENAME));
		meta.setConvertor(json.optString(JSONConstants.TABLE_CONVERTOR));

		
		JSONArray array = json.optJSONArray(JSONConstants.TABLE_COLUMNS);
		if( array != null ) {
			List<MetaColumn> list = UIJSONHandlerUtil.unbuild(MetaColumn.class, array);
			meta.addAll(list);
		}
		
		array = json.optJSONArray(JSONConstants.TABLE_PARAMETER_COLLECTION);
		if( array != null ) {
			MetaParameterCollection parameterCollection = new MetaParameterCollection();
			parameterCollection.addAll(0, UIJSONHandlerUtil.unbuild(MetaParameter.class, array));
			meta.setParameterCollection(parameterCollection);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.TABLE_STATEMENT);
		if( o != null ) {
			MetaStatement statement = UIJSONHandlerUtil.unbuild(MetaStatement.class, o);
			meta.setStatement(statement);
		}
	}

}