package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.util.MetaUtil;

public class MetaOperationJSONHandler extends AbstractJSONHandler<MetaOperation,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaOperation meta, DefaultSerializeContext hook)
			throws Throwable {
		// 处理refKey，即引用父定义的操作
		String refKey = meta.getRefKey();
		if ( refKey != null && !refKey.isEmpty() ) {
			if ( !meta.isRefKeyInited() ) {
				MetaUtil.processOperationRefKey(hook.getVE().getMetaFactory(), hook.getMetaForm(), meta);
			}
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_REFKEY, refKey);
		
		String caption = hook.getCaptionString(GroupKeyTable.STR_OPT, "", meta.getKey(), meta.getCaption(), meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_VISIBLECNT, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLEDEPENDENCY, meta.getVisibleDependency());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ENABLECNT, meta.getEnable());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLEDEPENDENCY, meta.getEnableDependency());
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_TYPE, meta.getObjectType());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_CSSCLASS, meta.getCssClass());
		
		MetaBaseScript action = meta.getAction();
		if( action != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ACTION, action.getContent().trim());			
		}

		MetaBaseScript preAction = meta.getPreAction();
		if (preAction != null && !preAction.isEmpty()) {
			JSONHelper.writeToJSON(json, JSONConstants.OPERATION_PREACTION, preAction.getContent().trim());		
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_TAG, meta.getTag());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_SHORTCUTS, meta.getShortCuts());
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_MANAGED, meta.isManaged());
		
		MetaBaseScript excepAction = meta.getExceptionHandler();
		if( excepAction != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.OPERATION_EXCPACTION, excepAction.getContent().trim());
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_EXPAND, meta.isExpand());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_EXPANDSOURCE, meta.getExpandSource());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_UPLOADFILE, meta.isUploadFile());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_UPLOADTYPE, meta.getUploadType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICONCODE, meta.getIconCode());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DISPLAYMODE, meta.getDisplayMode());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TCODE, meta.getTCode());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ACTIVITY, meta.getActivity());
		JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ISTRANSFER, meta.isTransfer());
	}

	@Override
	public void fromJSONImpl(MetaOperation meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setRefKey(json.optString(JSONConstants.OPERATION_REFKEY));
		
		meta.setVisible(json.optString(JSONConstants.OPERATION_VISIBLECNT));
		meta.setVisibleDependency(json.optString(JSONConstants.COMMON_VISIBLEDEPENDENCY));
		meta.setEnable(json.optString(JSONConstants.OPERATION_ENABLECNT));
		meta.setEnableDependency(json.optString(JSONConstants.COMMON_ENABLEDEPENDENCY));

		meta.setCssClass(json.optString(JSONConstants.OPERATION_CSSCLASS));
		
		String s = json.optString(JSONConstants.OPERATION_ACTION);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript action = new MetaBaseScript(MetaConstants.Event_Action);
			action.setContent(s);
			meta.setAction(action);
		}
		
		s = json.optString(JSONConstants.OPERATION_PREACTION);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript preAction = new MetaBaseScript(MetaConstants.Event_PreAction);
			preAction.setContent(s);
			meta.setPreAction(preAction);
		}
		meta.setTag(json.optString(JSONConstants.OPERATION_TAG));
		meta.setIcon(json.optString(JSONConstants.OPERATION_ICON));
		meta.setShortCuts(json.optString(JSONConstants.OPERATION_SHORTCUTS));
		meta.setManaged(json.optBoolean(JSONConstants.OPERATION_MANAGED));

		s = json.optString(JSONConstants.OPERATION_EXCPACTION);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript excepAction = new MetaBaseScript(MetaConstants.Event_ExceptionHandler);
			excepAction.setContent(s);
			meta.setExceptionHandler(excepAction);
		}
		
		meta.setExpand(json.optBoolean(JSONConstants.OPERATION_EXPAND));
		meta.setExpandSource(json.optString(JSONConstants.OPERATION_EXPANDSOURCE));
		meta.setUploadFile(json.optBoolean(JSONConstants.OPERATION_UPLOADFILE));
		meta.setUploadType(json.optString(JSONConstants.OPERATION_UPLOADTYPE));
		meta.setIconCode(json.optString(JSONConstants.COMMON_ICONCODE));
		meta.setDisplayMode(json.optInt(JSONConstants.COMMON_DISPLAYMODE));
		meta.setTCode(json.optString(JSONConstants.COMMON_TCODE));
		meta.setActivity(json.optString(JSONConstants.COMMON_ACTIVITY));
		meta.setTransfer(json.optBoolean(JSONConstants.OPERATION_ISTRANSFER));
	}
	
	@Override
	public MetaOperation newInstance() {
		return new MetaOperation();
	}

}
