package com.bokesoft.yes.meta.json.form;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.form.anim.MetaAnimProperty;
import com.bokesoft.yigo.meta.form.anim.MetaAnimPropertyCollection;

public class MetaAnimItemJSONHandler extends AbstractJSONHandler<MetaAnimItem,DefaultSerializeContext>{
	
	@Override
	public void fromJSONImpl(MetaAnimItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setDuration(json.optLong(JSONConstants.ANIM_DURATION));
		meta.setMaxDuration(json.optLong(JSONConstants.ANIM_MAXDURATION));
		meta.setRepeatMode(json.optInt(JSONConstants.ANIM_REPEATMODE));
		meta.setStartOffset(json.optLong(JSONConstants.ANIM_STARTOFFSET));
		
		String s = json.optString(JSONConstants.ANIM_REPEATCOUNT);
		if (s != null && !s.isEmpty()) {
			meta.setRepeatCount(Integer.valueOf(s));
		}
		
		s = json.optString(JSONConstants.ANIM_FILLBEFORE);
		if (s != null && !s.isEmpty()) {
			meta.setFillBefore(Boolean.valueOf(s));
		}
		
		s = json.optString(JSONConstants.ANIM_FILLAFTER);
		if (s != null && !s.isEmpty()) {
			meta.setFillAfter(Boolean.valueOf(s));
		}
		
		meta.setInterpolator(json.optInt(JSONConstants.ANIM_INTERPOLATOR));
		meta.setDelay(Float.parseFloat(json.optString(JSONConstants.LAYOUTANIM_DELAY)));
		meta.setOrder(json.optInt(JSONConstants.LAYOUTANIM_ORDER));
		
		JSONArray array = json.optJSONArray(JSONConstants.ANIM_PROPERTIES);
		if( array != null ) {
			MetaAnimPropertyCollection collection = new MetaAnimPropertyCollection();
			List<MetaAnimProperty> list = UIJSONHandlerUtil.unbuild(MetaAnimProperty.class, array);
			collection.addAll(list);
			meta.setProperties(collection);
		}
		
		array = json.optJSONArray(JSONConstants.ANIM_ITEMS);
		if( array != null ) {
			List<MetaAnimItem> list = UIJSONHandlerUtil.unbuild(MetaAnimItem.class, array);
			meta.addAll(0, list);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaAnimItem meta, DefaultSerializeContext hook) throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_DURATION, meta.getDuration());
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_MAXDURATION, meta.getMaxDuration());
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_REPEATMODE, meta.getRepeatMode());
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_STARTOFFSET, meta.getStartOffset());
		
		Integer repeatCount = meta.getRepeatCount();
		if (repeatCount != null) {
			JSONHelper.writeToJSON(json, JSONConstants.ANIM_REPEATCOUNT, meta.getRepeatCount());
		}
		
		Boolean fillAfter = meta.getFillAfter();
		if (fillAfter != null) {
			JSONHelper.writeToJSON(json, JSONConstants.ANIM_FILLAFTER, fillAfter);
		}
		
		Boolean fillBefore = meta.getFillBefore();
		if (fillBefore != null) {
			JSONHelper.writeToJSON(json, JSONConstants.ANIM_FILLBEFORE, fillBefore);
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_INTERPOLATOR, meta.getInterpolator());
		JSONHelper.writeToJSON(json, JSONConstants.LAYOUTANIM_DELAY, meta.getDelay() + "");
		JSONHelper.writeToJSON(json, JSONConstants.LAYOUTANIM_ORDER, meta.getOrder());
		
		MetaAnimPropertyCollection properties = meta.getProperties();
		if( properties != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, properties);
			JSONHelper.writeToJSON(json, JSONConstants.ANIM_PROPERTIES, array);
		}
		
		JSONArray items = new JSONArray();
		for( MetaAnimItem item : meta ) {
			JSONObject o = UIJSONHandlerUtil.build(item,hook);
			items.put(o);
		}
		JSONHelper.writeToJSON(json, JSONConstants.ANIM_ITEMS, items);
	}

	@Override
	public MetaAnimItem newInstance() {
		return new MetaAnimItem();
	}

}
