package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;

public class MetaToggleButtonPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaToggleButtonProperties>{

	@Override
	public void toJSONImpl(JSONObject json, MetaToggleButtonProperties meta, DefaultSerializeContext hook, String key)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COLLAPSE_TEXTON, meta.getTextOn());
		JSONHelper.writeToJSON(json, JSONConstants.COLLAPSE_TEXTOFF, meta.getTextOff());	
		JSONHelper.writeToJSON(json, JSONConstants.TOGGLEBUTTON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.TOGGLEBUTTON_ICONON, meta.getIconOn());
		JSONHelper.writeToJSON(json, JSONConstants.TOGGLEBUTTON_ICONOFF, meta.getIconOff());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ICONLOCATION, meta.getIconLocation());
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim());
		}
	}

	@Override
	public void fromJSONImpl(MetaToggleButtonProperties meta, JSONObject json) throws Throwable {
		meta.setTextOn(json.optString(JSONConstants.COLLAPSE_TEXTON));
		meta.setTextOff(json.optString(JSONConstants.COLLAPSE_TEXTOFF));
		meta.setIcon(json.optString(JSONConstants.TOGGLEBUTTON_ICON));
		meta.setIconOn(json.optString(JSONConstants.TOGGLEBUTTON_ICONON));
		meta.setIconOff(json.optString(JSONConstants.TOGGLEBUTTON_ICONOFF));
		meta.setIconLocation(json.optInt(JSONConstants.BUTTON_ICONLOCATION));
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
	}
	
	@Override
	public MetaToggleButtonProperties newInstance() {
		return new MetaToggleButtonProperties();
	}

}
