package com.bokesoft.yes.meta.json.com.properties;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarProperties;

public class MetaProgressBarPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaProgressBarProperties>{

	@Override
	public void toJSONImpl(JSONObject json, MetaProgressBarProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_MAXPOS, meta.getMaxPos());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_MINPOS, meta.getMinPos());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_DYNAMIC, meta.isDynamic());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_BARCOLOR, meta.getBarColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_PROGRESSCOLOR, meta.getProgressColor());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_STEPVALUE, meta.getStepValue());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_STYLE, meta.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_REPEAT, meta.isRepeat());
		JSONArray items = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, items);
	}
	
	@Override
	public void fromJSONImpl(MetaProgressBarProperties meta, JSONObject json) throws Throwable {
		meta.setMaxPos(json.optInt(JSONConstants.PROGRESSBAR_MAXPOS));
		meta.setMinPos(json.optInt(JSONConstants.PROGRESSBAR_MINPOS));
		meta.setDynamic(json.optBoolean(JSONConstants.PROGRESSBAR_DYNAMIC));
		meta.setBarColor(json.optString(JSONConstants.PROGRESSBAR_BARCOLOR));
		meta.setProgressColor(json.optString(JSONConstants.PROGRESSBAR_PROGRESSCOLOR));
		meta.setStepValue(json.optInt(JSONConstants.PROGRESSBAR_STEPVALUE));
		meta.setStyle(json.optInt(JSONConstants.PROGRESSBAR_STYLE));
		meta.setRepeat(json.optBoolean(JSONConstants.PROGRESSBAR_REPEAT));
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaProgressBarItem> list = UIJSONHandlerUtil.unbuild(MetaProgressBarItem.class, array);
			meta.addAll(0, list);
		}
	}

	@Override
	public MetaProgressBarProperties newInstance() {
		return new MetaProgressBarProperties();
	}
	
}
