package com.bokesoft.yes.meta.json.com.listView;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewRow;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;

public class MetaListViewRowJSONHandler extends AbstractJSONHandler<MetaListViewRow,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaListViewRow meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SEPARATORSTYLE, meta.getSeparatorStyle());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SEPARATORRADIUS, meta.getSeparatorRadius());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SEPARATORCOLOR, meta.getSeparatorColor());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SELECTCOLOR, meta.getSelectColor());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_HIGHLIGHTCOLOR, meta.getHighlightColor());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_TOPMARGIN, meta.getTopMargin());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_GAP, meta.getRowGap());
		DefSize offset = meta.getSeparatorOffset();
		if( offset != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_SEPARATOROFFSET, offset.toString(), "");
		}
				
		MetaRowActionCollection collection = meta.getActionCollection();
		if( collection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, collection);
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_ACTION_COLLECTION, array);
		}
	}

	@Override
	public void fromJSONImpl(MetaListViewRow meta, JSONObject json) throws Throwable {
		meta.setSeparatorStyle(json.optString(JSONConstants.LISTVIEW_ROW_SEPARATORSTYLE));
		meta.setSeparatorRadius(json.optInt(JSONConstants.LISTVIEW_ROW_SEPARATORRADIUS));
		meta.setSeparatorColor(json.optString(JSONConstants.LISTVIEW_ROW_SEPARATORCOLOR));
		meta.setSelectColor(json.optString(JSONConstants.LISTVIEW_ROW_SELECTCOLOR));
		meta.setHighlightColor(json.optString(JSONConstants.LISTVIEW_ROW_HIGHLIGHTCOLOR));
		meta.setBackColor(json.optString(JSONConstants.LISTVIEW_ROW_BACKCOLOR));
		meta.setTopMargin(json.optString(JSONConstants.LISTVIEW_ROW_TOPMARGIN));
		meta.setRowGap(json.optInt(JSONConstants.LISTVIEW_ROW_GAP));
		
		String s = json.optString(JSONConstants.LISTVIEW_ROW_SEPARATOROFFSET);
		if( s != null && !s.isEmpty() ) {
			meta.setSeparatorOffset(DefSize.parse(s));
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.LISTVIEW_ROW_ACTION_COLLECTION);
		if( array != null ) {
			MetaRowActionCollection actionCollection = new MetaRowActionCollection();
			List<MetaRowAction> list = UIJSONHandlerUtil.unbuild(MetaRowAction.class, array);
			actionCollection.addAll(list);
			meta.setActionCollection(actionCollection);
		}
	}

	@Override
	public MetaListViewRow newInstance() {
		return new MetaListViewRow();
	} 

}
