package com.bokesoft.yes.meta.json.com.listView;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaListLayoutView;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayout;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayoutCollection;

public class MetaListLayoutViewJSONHandler extends MetaListViewJSONHandler<MetaListLayoutView>{

	@Override
	public void toJSONImpl(JSONObject json, MetaListLayoutView meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.LISTLAYOUTVIEW_REPEATCOUNT, meta.getRepeatCount());
		MetaRowLayoutCollection layoutCollection = meta.getRowLayoutCollection();
		if( layoutCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, layoutCollection);
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROWLAYOUTINFO, array);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaListLayoutView meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setRepeatCount(json.optInt(JSONConstants.LISTLAYOUTVIEW_REPEATCOUNT));
		
		JSONArray array = json.optJSONArray(JSONConstants.LISTVIEW_ROWLAYOUTINFO);
		if( array != null ) {
			MetaRowLayoutCollection rowLayoutCollection = new MetaRowLayoutCollection();
			List<MetaRowLayout> list = UIJSONHandlerUtil.unbuild(MetaRowLayout.class, array);
			rowLayoutCollection.addAll(list);
			meta.setRowLayoutCollection(rowLayoutCollection);
		}
	}
	
	@Override
	public MetaListLayoutView newInstance() {
		return new MetaListLayoutView();
	}
}
