package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;

public class MetaFilterValueJSONHandler extends AbstractJSONHandler<MetaFilterValue,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaFilterValue meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FIELDKEY, meta.getFieldKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_REFVALUE, meta.getRefValueKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_PARAVALUE, meta.getParaValue());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DATATYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_SIGN, meta.getSign());
	}

	@Override
	public void fromJSONImpl(MetaFilterValue meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setFieldKey(json.optString(JSONConstants.COMMON_FIELDKEY));
		meta.setRefValue(json.optString(JSONConstants.GRID_REFVALUE));
		meta.setParaValue(json.optString(JSONConstants.GRID_PARAVALUE));
		meta.setDataType(json.optInt(JSONConstants.COMMON_DATATYPE));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setSign(json.optInt(JSONConstants.COMMON_SIGN));
	}

	@Override
	public MetaFilterValue newInstance() {
		return new MetaFilterValue();
	}

}
