package com.bokesoft.yes.meta.json.com.gantt;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttColumn;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttRow;
import org.json.JSONObject;

public class MetaGanttRowJSONHandler extends AbstractJSONHandler<MetaGanttRow, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaGanttRow meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, "startTime", meta.getStartTime());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_ENDTIME, meta.getEndTime());
		JSONHelper.writeToJSON(json, "cssClass", meta.getCssClass());
		JSONHelper.writeToJSON(json, "visible", meta.getVisible());
		JSONHelper.writeToJSON(json, "text", meta.getText());
		JSONHelper.writeToJSON(json, "showRelation", meta.getShowRelation());
		JSONHelper.writeToJSON(json, "shape", meta.getShape());
	}

	@Override
	public void fromJSONImpl(MetaGanttRow meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setStartTime(json.optString("startTime"));
		meta.setEndTime(json.optString(JSONConstants.GANTT_ENDTIME));
		meta.setCssClass(json.optString("cssClass"));
		meta.setVisible(json.optString("visible"));
		meta.setText(json.optString("text"));
		meta.setShowRelation(json.optBoolean("showRelation"));
		meta.setShape(json.optString("shape"));
	}

	@Override
	public MetaGanttRow newInstance() {
		return new MetaGanttRow();
	}

}
