package com.bokesoft.yes.meta.json.com.gantt;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGantt;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttTable;

public class MetaGanttJSONHandler extends BaseComponentJSONHandler<MetaGantt> {

	@Override
	public void fromJSONImpl(MetaGantt meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);

		JSONObject o = json.optJSONObject(JSONConstants.GANTT_TABLE);
		if (o != null) {
			MetaGanttTable ganttTable = UIJSONHandlerUtil.unbuild(MetaGanttTable.class, o);
			meta.setGanttTable(ganttTable);
		}

	}

	@Override
	public void toJSONImpl(JSONObject json, MetaGantt meta, DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);

		MetaGanttTable ganttTable = meta.getGanttTable();
		if (ganttTable != null) {
			JSONObject tableObject = UIJSONHandlerUtil.build(ganttTable, hook);
			JSONHelper.writeToJSON(json, JSONConstants.GANTT_TABLE, tableObject);
		}

	}

	@Override
	public MetaGantt newInstance() {
		return new MetaGantt();
	}
}
