package com.bokesoft.yes.meta.json.com.gantt;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttColumn;

public class MetaGanttColumnJSONHandler extends AbstractJSONHandler<MetaGanttColumn, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaGanttColumn meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_COLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_COLUMNTYPE, meta.getColumnType());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_TREE, meta.isTree());
		JSONHelper.writeToJSON(json, JSONConstants.DATEPICKER_FORMATSTR, meta.getFormat());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.isVisible());
		JSONHelper.writeToJSON(json, "dateFormat", meta.getDateFormat());
		JSONHelper.writeToJSON(json, "width", meta.getWidth());
		JSONHelper.writeToJSON(json, "dateTimeFormat", meta.getDateTimeFormat());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue());
	}

	@Override
	public void fromJSONImpl(MetaGanttColumn meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setColumnKey(json.optString(JSONConstants.COMMON_COLUMNKEY));
		meta.setColumnType(json.optInt(JSONConstants.GANTT_COLUMNTYPE));
		meta.setTree(json.optBoolean(JSONConstants.GANTT_TREE));
		meta.setFormat(json.optString(JSONConstants.DATEPICKER_FORMATSTR));
		meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		meta.setDateTimeFormat(json.optString("dateTimeFormat"));
		meta.setDateFormat(json.optString("dateFormat"));
		meta.setWidth(json.optString("width"));
		meta.setDefaultFormulaValue(json.optString(JSONConstants.COMMON_DEFAULTFORMULAVALUE));
	}

	@Override
	public MetaGanttColumn newInstance() {
		return new MetaGanttColumn();
	}

}
