package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.listlayoutview.MetaRowLayout;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;

public class MetaRowLayoutJSONHandler extends AbstractJSONHandler<MetaRowLayout,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaRowLayout meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		
		MetaPanel layout = meta.getLayout();
		if( layout != null ) {			
			JSONObject o = UIJSONHandlerUtil.build(layout,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_LAYOUT, o);
		}
		
	}

	@Override
	public void fromJSONImpl(MetaRowLayout meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_LAYOUT);
		if( o != null ) {
			MetaPanel layout = (MetaPanel) UIJSONHandlerUtil.unbuild(o);
			meta.setLayout(layout);
		}
	}

	@Override
	public MetaRowLayout newInstance() {
		return new MetaRowLayout();
	}

}
