package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;

public class MetaSwimlinePositionJSONHandler extends AbstractJSONHandler<MetaSwimlinePosition, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaSwimlinePosition meta, JSONObject json) throws Throwable {
		meta.setX(json.optInt(JSONConstants.POSITION_X));
		meta.setY(json.optInt(JSONConstants.POSITION_Y));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSwimlinePosition meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.POSITION_X, meta.getX());
		JSONHelper.writeToJSON(json, JSONConstants.POSITION_Y, meta.getY());	
	}
	
	@Override
	public MetaSwimlinePosition newInstance() {
		return new MetaSwimlinePosition();
	}
}
