package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaComplexJoin;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaComplexJoinJSONHandler extends MetaJoinJSONHandler<MetaComplexJoin> {
	
	@Override
	public void fromJSONImpl(MetaComplexJoin meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		String s = json.optString(JSONConstants.NODE_JOIN_CONDITION);
		if(s.length() > 0){
			MetaBaseScript joinCondition = new MetaBaseScript(BPMConstants.NODE_JOIN_CONDITION);
			joinCondition.setContent(s);
			meta.setJoinCondition(joinCondition);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaComplexJoin meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaBaseScript joinCondition = meta.getJoinCondition();
		if(joinCondition != null){
			JSONHelper.writeToJSON(json, JSONConstants.NODE_JOIN_CONDITION, joinCondition.getContent().trim());
		}
	}
	
	@Override
	public MetaComplexJoin newInstance() {
		return new MetaComplexJoin();
	}
}
