/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.form;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.action.form.MetaComponentDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;
import com.bokesoft.yigo.meta.form.component.control.MetaStateList;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateListProperties;

public class MetaStateListDiffAction
extends MetaComponentDiffAction<MetaStateList> {
    @Override
    public boolean mergeDiffNode(final MetaStateList baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        super.mergeDiffNode(baseMeta, metaDiff, metaDiffNode, context);
        final IKeyPairElements stateItems = CollectionUtil.trans2KeyPairElements(((MetaStateListProperties)baseMeta.getProperties()).getItems());
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "StateItemCollection": {
                        ((MetaStateListProperties)baseMeta.getProperties()).setItems((MetaStateItemCollection)meta.clone());
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                switch (meta.getDeleteTag()) {
                    case "StateItem": {
                        stateItems.deleteElement(meta);
                        return;
                    }
                }
            }

            public void mergeAdd(MetaAdd meta) {
                if (meta.getBase() instanceof MetaStateItem) {
                    stateItems.addElement(meta);
                }
            }

            public boolean mergeMoveCollection(MetaMoveCollection moveCollection) {
                stateItems.moveElements(moveCollection);
                return true;
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaStateList oldMeta, MetaStateList newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        super.divideSubNode(oldMeta, newMeta, oldParent, diffNode, metaDiff, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(((MetaStateListProperties)oldMeta.getProperties()).getItems()), CollectionUtil.trans2KeyPairElements(((MetaStateListProperties)newMeta.getProperties()).getItems()), diffNode, metaDiff, (AbstractMetaObject)((MetaStateListProperties)oldMeta.getProperties()).getItems(), (AbstractMetaObject)oldMeta, context);
    }
}

