/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.form;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaMove;
import com.bokesoft.yigo.meta.diff.action.form.MetaComponentDiffAction;
import com.bokesoft.yigo.meta.diff.collection.component.ComponentElement;
import com.bokesoft.yigo.meta.diff.collection.component.ComponentElementCollection;
import com.bokesoft.yigo.meta.diff.impl.IDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElement;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import java.util.ArrayList;
import java.util.Collection;

public class MetaBlockDiffAction
extends MetaComponentDiffAction<MetaBlock> {
    @Override
    public boolean mergeDiffNode(MetaBlock baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        ComponentElementCollection baseComponents = new ComponentElementCollection(baseMeta);
        Collection<ComponentElement> baseComponentCollection = baseComponents.getElementsList();
        final ComponentElementCollection componentsAll = new ComponentElementCollection(baseMeta);
        if (metaDiffNode != null) {
            metaDiffNode.mergeDiff(new IMergeDiffAction(){

                public void mergeDelete(MetaDelete meta) {
                    componentsAll.deleteElement(meta);
                }

                public void mergeAdd(MetaAdd meta) {
                    componentsAll.addElement(meta);
                }

                public void mergeMove(MetaMove move) {
                    componentsAll.moveElement(move);
                }
            });
        }
        for (ComponentElement baseDiffComp : baseComponentCollection) {
            ComponentElement container = baseComponents.getContainer(baseDiffComp);
            this.mergeDiffChild((AbstractMetaObject)baseDiffComp.getMeta(), (AbstractMetaObject)(container == null ? null : container.getMeta()), null, metaDiff, context);
        }
        return false;
    }

    @Override
    public void divideSubNode(MetaBlock oldMeta, MetaBlock newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        this.divideBlock(CollectionUtil.trans2KeyPairElements(oldMeta), CollectionUtil.trans2KeyPairElements(newMeta), diffNode, metaDiff, context);
    }

    private void divideBlock(IKeyPairElements<ComponentElement> oldElements, IKeyPairElements<ComponentElement> newElements, MetaDiffNode metaDiffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        Collection<ComponentElement> oldElementCollection = oldElements.getElementsList();
        Collection<ComponentElement> newElementCollection = newElements.getElementsList();
        for (ComponentElement newElement : newElementCollection) {
            ComponentElement container;
            MetaComponent newElementMeta = newElement.getMeta();
            if (oldElements.containsKey(newElement.getKey(), null) || (container = newElements.getContainer(newElement)) == null) continue;
            if (newElementMeta instanceof MetaPanel) {
                MetaPanel newPanel = this.clonePanelWithoutChildren((MetaPanel)newElementMeta);
                metaDiffNode.recordAdd(newElement.getKey(), newElement.getPreviousKey(), container.getTagName(), container.getKey(), (AbstractMetaObject)newPanel);
                continue;
            }
            metaDiffNode.recordAdd(newElement.getKey(), newElement.getPreviousKey(), container.getTagName(), container.getKey(), (AbstractMetaObject)newElementMeta);
        }
        for (ComponentElement oldElement : oldElementCollection) {
            String key = oldElement.getKey();
            ComponentElement newElement = newElements.getElement(key, oldElement.getTagName());
            ComponentElement oldContainer = oldElements.getContainer(oldElement);
            if (newElement == null) {
                metaDiffNode.recordDelete((KeyPairMetaObject)oldElement.getMeta(), null);
                continue;
            }
            if (!oldElement.getPreviousKey().equals(newElement.getPreviousKey()) || !oldElement.getContainerKey().equals(newElement.getContainerKey())) {
                IKeyPairElement next;
                MetaMove metaMove = MetaMove.create((String)key, (String)newElement.getTagName(), (String)"", (String)newElement.getContainerKey(), (String)newElement.getPreviousKey());
                metaDiffNode.recordMove(metaMove);
                if (oldElement.getNext() != null && oldElements.containsKey(newElement.getPreviousKey(), null) && (next = (IKeyPairElement)newElements.getElement(oldElement.getNextKey(), null)) != null) {
                    oldElement.getNext().setPrevious(next.getPrevious());
                }
                MetaBlockDiffAction.divideDiffKeyMeta(key, oldElement, newElement, oldContainer, metaDiff, context);
                continue;
            }
            MetaBlockDiffAction.divideDiffKeyMeta(key, oldElement, newElement, oldContainer, metaDiff, context);
        }
    }

    public static void divideDiffKeyMeta(String key, ComponentElement oldDiffMeta, ComponentElement newDiffMeta, ComponentElement container, MetaDiff metaDiff, IDiffContext context) throws Exception {
        MetaComponent oldMeta = oldDiffMeta.getMeta();
        MetaComponent newMeta = newDiffMeta.getMeta();
        MetaComponent parent = container == null ? null : container.getMeta();
        IDiffAction action = context.getActionMap().getDiffAction((AbstractMetaObject)oldMeta);
        if (action != null) {
            action.doDivide(oldMeta.getKey(), (AbstractMetaObject)oldMeta, (AbstractMetaObject)newMeta, metaDiff, (AbstractMetaObject)parent, null, context);
        }
    }

    private MetaPanel clonePanelWithoutChildren(MetaPanel newMetaPanel) throws Exception {
        ArrayList listComps = newMetaPanel.getComponentArray();
        newMetaPanel.setComponentArray(null);
        MetaPanel panelWithoutChildren = (MetaPanel)newMetaPanel.clone();
        newMetaPanel.setComponentArray(listComps);
        return panelWithoutChildren;
    }

    @Override
    protected boolean canMergeWithoutDiffNode() {
        return true;
    }
}

