/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.datamigration;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTable;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.action.AbstractMetaDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;

public class MetaDMSourceTableDiffAction
extends AbstractMetaDiffAction<MetaDMSourceTable> {
    @Override
    public boolean mergeDiffNode(final MetaDMSourceTable baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        final IKeyPairElements allFields = CollectionUtil.trans2KeyPairElements(baseMeta);
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "SourceTable": {
                        MetaDMSourceTable newSourceTable = (MetaDMSourceTable)meta.clone();
                        baseMeta.clear();
                        for (MetaDMSourceField metaDMSourceField : newSourceTable) {
                            baseMeta.add((KeyPairMetaObject)metaDMSourceField);
                        }
                        break;
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                allFields.deleteElement(meta);
            }

            public void mergeAdd(MetaAdd meta) {
                allFields.addElement(meta);
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaDMSourceTable oldMeta, MetaDMSourceTable newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta), CollectionUtil.trans2KeyPairElements(newMeta), diffNode, metaDiff, (AbstractMetaObject)oldMeta, null, context);
    }
}

