/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelListItem;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExcelTemplateFieldFormat {
    private JSONObject content = null;

    public ExcelTemplateFieldFormat() {
        this("{}");
    }

    public ExcelTemplateFieldFormat(String sJson) {
        this.content = new JSONObject(sJson);
    }

    public int getDataType() {
        if (!this.content.has("DataType")) {
            return 0;
        }
        return ExcelFormatDataType.parse((String)this.content.getString("DataType"));
    }

    public void setDataType(int type) {
        if (this.getDataType() == type) {
            return;
        }
        this.content.put("DataType", (Object)ExcelFormatDataType.toString((Integer)type));
    }

    public String getItemKey() {
        if (!this.content.has("ItemKey")) {
            return "";
        }
        return this.content.getString("ItemKey");
    }

    public void setItemKey(String itemKey) {
        if (StringUtil.isBlankOrNull((String)itemKey)) {
            return;
        }
        this.content.put("ItemKey", (Object)itemKey);
    }

    public String getFieldKeys() {
        if (!this.content.has("FieldKeys")) {
            return "";
        }
        return this.content.getString("FieldKeys");
    }

    public void setFieldKeys(String fieldKeys) {
        if (StringUtil.isBlankOrNull((String)fieldKeys)) {
            return;
        }
        this.content.put("FieldKeys", (Object)fieldKeys);
    }

    public String getFormatString() {
        if (!this.content.has("Format")) {
            return "";
        }
        return this.content.getString("Format");
    }

    public void setFormatString(String formatString) {
        if (StringUtil.isBlankOrNull((String)formatString)) {
            return;
        }
        this.content.put("Format", (Object)formatString);
    }

    public void addListItem(String value, String text) {
        if (!this.content.has("ListItem")) {
            this.content.put("ListItem", (Object)new JSONArray());
        }
        JSONObject jsonItem = new JSONObject();
        jsonItem.put("Value", (Object)value);
        jsonItem.put("Text", (Object)text);
        ((JSONArray)this.content.get("ListItem")).put((Object)jsonItem);
    }

    public List<ExcelListItem> getListItems() {
        ArrayList<ExcelListItem> listItems = new ArrayList<ExcelListItem>();
        if (this.content.has("ListItem")) {
            JSONArray items = (JSONArray)this.content.get("ListItem");
            for (int index = 0; index < items.length(); ++index) {
                JSONObject item = (JSONObject)items.get(index);
                listItems.add(new ExcelListItem(item.get("Value"), item.getString("Text")));
            }
        }
        return listItems;
    }

    public void setStorageService(String storage) {
        if (StringUtil.isBlankOrNull((String)storage)) {
            return;
        }
        this.content.put("StorageService", (Object)storage);
    }

    public String getStorageService() {
        if (!this.content.has("StorageService")) {
            return "";
        }
        return this.content.getString("StorageService");
    }

    public boolean isNullFormatStyle() {
        return "{}".equals(this.toString()) || StringUtil.isBlankOrNull((String)this.toString());
    }

    public String toString() {
        return this.content.toString();
    }
}

