/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yigo.common.struct.IKeyPair;
import com.bokesoft.yigo.struct.expand.IExpandTableDefine;
import java.util.ArrayList;
import java.util.List;

public class ExcelTemplateTable
implements IKeyPair,
IExpandTableDefine<ExcelTemplateField, ExcelTemplateField> {
    private String tableKey = null;
    private int startTemplateDtlRowIndex = 0;
    private boolean isDtlTable = false;
    private List<ExcelTemplateField> listFields = null;
    private int rowHeight = -1;
    private HashMapIgnoreCase<ExcelTemplateField> mapFields = null;
    private ArrayList<ExcelTemplateField> detailHeadFields = null;

    public ExcelTemplateTable(String tableKey) {
        this.tableKey = tableKey;
        this.listFields = new ArrayList<ExcelTemplateField>();
        this.mapFields = new HashMapIgnoreCase();
        this.detailHeadFields = new ArrayList();
    }

    public void setTableKey(String tableKey) {
        this.tableKey = tableKey;
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public void setStartDtlRowIndex(int startDtlRowIndex) {
        this.startTemplateDtlRowIndex = startDtlRowIndex;
    }

    public int getStartDtlRowIndex() {
        return this.startTemplateDtlRowIndex;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setDtlTable(boolean isDtlTable) {
        this.isDtlTable = isDtlTable;
    }

    public boolean isDtlTable() {
        return this.isDtlTable;
    }

    public void addField(ExcelTemplateField templateField) {
        this.listFields.add(templateField);
        this.mapFields.put(templateField.getKey(), (Object)templateField);
    }

    public void remove(ExcelTemplateField templateField) {
        this.listFields.remove(templateField);
        this.mapFields.remove(templateField.getKey());
    }

    public void remove(String templateFieldKey) {
        this.listFields.remove(this.getField(templateFieldKey));
        this.mapFields.remove(templateFieldKey);
    }

    public int getFieldCount() {
        return this.listFields.size();
    }

    public List<ExcelTemplateField> getFields() {
        return this.listFields;
    }

    public ExcelTemplateField getTemplateField(int index) {
        return this.listFields.get(index);
    }

    public String getSheetName() {
        if (this.listFields.size() > 0) {
            return this.listFields.get(0).getSheetName();
        }
        return "";
    }

    public ExcelTemplateField getDetailLinkedField() {
        if (this.listFields.size() > 0 && this.listFields.get(0).isDetailLinkField()) {
            return this.listFields.get(0);
        }
        return null;
    }

    public ExcelTemplateField getFirstField() {
        if (this.listFields.size() > 0) {
            return this.listFields.get(0);
        }
        return null;
    }

    public boolean existDetailLinkedField() {
        if (this.listFields.size() > 0) {
            return this.listFields.get(0).isDetailLinkField();
        }
        return false;
    }

    public ExcelTemplateField getField(String fieldKey) {
        return (ExcelTemplateField)this.mapFields.get(fieldKey);
    }

    public void fillDetailHeadFields(List<ExcelTemplateField> detailHeadFields) {
        for (ExcelTemplateField detailHeadField : detailHeadFields) {
            this.detailHeadFields.add(detailHeadField);
        }
    }

    public List<ExcelTemplateField> getDetailHeadFields() {
        return this.detailHeadFields;
    }

    public ExcelTemplateField getDetailHeadField(int colIndex) {
        for (ExcelTemplateField detailHeadField : this.detailHeadFields) {
            if (detailHeadField.getColIndex() != colIndex) continue;
            return detailHeadField;
        }
        return null;
    }

    public int getFirstRowIndex() {
        int firstRowIndex = Integer.MAX_VALUE;
        for (ExcelTemplateField detailHeadField : this.detailHeadFields) {
            firstRowIndex = Math.min(firstRowIndex, detailHeadField.getRowIndex());
        }
        for (ExcelTemplateField field : this.listFields) {
            firstRowIndex = Math.min(firstRowIndex, field.getRowIndex());
        }
        return firstRowIndex;
    }

    public boolean hasDetailHead() {
        return this.detailHeadFields.size() > 0;
    }

    public boolean hasExpandField() {
        if (!this.isDtlTable) {
            return false;
        }
        for (ExcelTemplateField field : this.listFields) {
            if (!field.isExpandField()) continue;
            return true;
        }
        return false;
    }

    public void shiftCellIndexAfter(int expandRowIndex, int expandCellIndex, int inc) {
        for (ExcelTemplateField field : this.listFields) {
            if (expandRowIndex != field.getRowIndex() || field.getColIndex() <= expandCellIndex) continue;
            field.setColIndex(field.getColIndex() + inc);
            if (!field.isExpandField()) continue;
            ExcelTemplateField dimenField = null;
            for (String dimenFieldKey : field.getDimensionFieldKeys()) {
                dimenField = this.getField(dimenFieldKey);
                dimenField.setColIndex(dimenField.getColIndex() + inc);
            }
        }
        for (ExcelTemplateField detailHeadField : this.detailHeadFields) {
            if (detailHeadField.getColIndex() <= expandCellIndex) continue;
            detailHeadField.setColIndex(detailHeadField.getColIndex() + inc);
        }
    }

    public String getKey() {
        return this.getTableKey();
    }

    public List<ExcelTemplateField> getExpandFields() {
        ArrayList<ExcelTemplateField> expandFields = new ArrayList<ExcelTemplateField>();
        for (ExcelTemplateField field : this.listFields) {
            if (!field.isExpandField()) continue;
            expandFields.add(field);
        }
        return expandFields;
    }

    public List<String> getFixedFieldKeys() {
        ArrayList<String> fixedFields = new ArrayList<String>();
        for (ExcelTemplateField field : this.listFields) {
            if (field.getSourceType() == 2 || !field.getColumnExpand().isNull()) continue;
            fixedFields.add(field.getKey());
        }
        return fixedFields;
    }

    public ExcelTemplateField getNextFieldInSameRow(ExcelTemplateField curField) {
        int curIndex = this.listFields.indexOf(curField);
        ExcelTemplateField nextField = null;
        for (int nextIndex = curIndex + 1; nextIndex < this.listFields.size(); ++nextIndex) {
            nextField = this.listFields.get(nextIndex);
            if (nextField.getRowIndex() != curField.getRowIndex() || nextField.getColIndex() <= curField.getColIndex()) continue;
            return nextField;
        }
        return null;
    }

    public ExcelTemplateField getDimensionField(String key) {
        return this.getField(key);
    }

    public ExcelTemplateField getExpandSourceField(String dimenFieldKey) {
        for (ExcelTemplateField field : this.listFields) {
            if (!field.isExpandField() || !field.getDimensionFieldKeys().contains(dimenFieldKey)) continue;
            return field;
        }
        return null;
    }
}

