/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandSourceType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandType;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExcelTemplateColumnExpand {
    public static final String EXPAND_ExpandContent = "ExpandContent";
    public static final String EXPAND_ExpandDimensionFields = "ExpandDimensionFields";
    private JSONObject content = null;

    public ExcelTemplateColumnExpand() {
        this("{}");
    }

    public ExcelTemplateColumnExpand(String sJson) {
        if (StringUtil.isBlankOrNull((String)sJson)) {
            sJson = "{}";
        }
        this.content = new JSONObject(sJson);
    }

    public int getExpandType() {
        if (!this.content.has("ExpandType")) {
            return 1;
        }
        return ExcelTemplateColumnExpandType.parse((String)this.content.getString("ExpandType"));
    }

    public void setExpandType(int type) {
        if (type == this.getExpandType()) {
            return;
        }
        this.content.put("ExpandType", (Object)ExcelTemplateColumnExpandType.toString((int)type));
    }

    public int getExpandSourceType() {
        if (!this.content.has("ExpandSourceType")) {
            return 1;
        }
        return ExcelTemplateColumnExpandSourceType.parse((String)this.content.getString("ExpandSourceType"));
    }

    public void setExpandSourceType(int type) {
        if (type == this.getExpandSourceType()) {
            return;
        }
        this.content.put("ExpandSourceType", (Object)ExcelTemplateColumnExpandSourceType.toString((int)type));
    }

    public String getExpandContent() {
        if (!this.content.has(EXPAND_ExpandContent)) {
            return "";
        }
        return this.content.getString(EXPAND_ExpandContent);
    }

    public void setExpandContent(String expandContent) {
        if (expandContent.equals(this.getExpandContent())) {
            return;
        }
        this.content.put(EXPAND_ExpandContent, (Object)expandContent);
    }

    public boolean hasExpand() {
        return this.getExpandDimensionFields().size() > 0;
    }

    public ArrayList<String> getExpandDimensionFields() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.content.has(EXPAND_ExpandDimensionFields)) {
            return new ArrayList<String>();
        }
        JSONArray array = this.content.getJSONArray(EXPAND_ExpandDimensionFields);
        for (int i = 0; i < array.length(); ++i) {
            list.add(array.getString(i));
        }
        return list;
    }

    public void addExpandDimensionField(String expandGroupFieldKey) {
        JSONArray jsonArray = null;
        if (!this.content.has(EXPAND_ExpandDimensionFields)) {
            jsonArray = new JSONArray();
            this.content.put(EXPAND_ExpandDimensionFields, (Object)jsonArray);
        }
        jsonArray = this.content.getJSONArray(EXPAND_ExpandDimensionFields);
        this.moveToAfterPosition(jsonArray);
        jsonArray.put(0, (Object)expandGroupFieldKey);
    }

    private void moveToAfterPosition(JSONArray jsonArray) {
        int len = jsonArray.length();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            jsonArray.put(i + 1, jsonArray.get(i));
        }
    }

    public boolean isNull() {
        return "{}".equals(this.toString()) || StringUtil.isBlankOrNull((String)this.toString());
    }

    public String toString() {
        return this.content.toString();
    }
}

