/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.dic.item;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.struct.dict.ItemTableMetaData;
import com.bokesoft.yes.struct.dict.ItemTableMetaDatas;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.concurrent.ConcurrentHashMap;

public class DictMetaDatasFactory {
    private static DictMetaDatasFactory INSTANCE = new DictMetaDatasFactory();
    private static ConcurrentHashMap<String, ItemTableMetaDatas> itemTableCache = new ConcurrentHashMap();

    public static DictMetaDatasFactory getInstance() {
        return INSTANCE;
    }

    public ItemTableMetaDatas getDictMetaDatas(VE ve, String itemKey) throws Throwable {
        if (!itemTableCache.containsKey(itemKey)) {
            MetaDataObject dataObj = ve.getMetaFactory().getDataObject(itemKey);
            if (dataObj == null) {
                throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataObjectDefined"), (Object[])new Object[]{itemKey}));
            }
            ItemTableMetaDatas metaDatas = new ItemTableMetaDatas(dataObj);
            String mainTableKey = dataObj.getMainTableKey();
            boolean isMainTable = false;
            for (MetaTable table : dataObj.getTableCollection()) {
                isMainTable = table.getKey().equals(mainTableKey);
                ItemTableMetaData metaData = new ItemTableMetaData(table, isMainTable);
                metaDatas.put((Object)table.getKey(), (Object)metaData);
            }
            metaDatas.init();
            itemTableCache.put(itemKey, metaDatas);
        }
        return itemTableCache.get(itemKey);
    }

    public void clear(String itemKey) {
        if (itemKey != null && itemTableCache.containsKey(itemKey)) {
            itemTableCache.remove(itemKey);
        }
    }
}

