/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.dic;

import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaDictPane;
import com.bokesoft.yigo.meta.form.component.control.MetaDictSearchBox;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.ve.VE;

public class DictCacheUtil {
    public static final Object getDictValue(VE ve, IDictCacheProxy dictCache, String itemKey, long oid, String fieldKey) throws Throwable {
        Object value = null;
        MetaDataObject dataObj = ve.getMetaFactory().getDataObject(itemKey);
        String tableKey = null;
        String colKey = null;
        int pos = fieldKey.indexOf(46);
        if (pos > 0) {
            tableKey = fieldKey.substring(0, pos);
            colKey = fieldKey.substring(pos + 1);
        } else {
            tableKey = dataObj.getMainTable().getKey();
            colKey = fieldKey;
        }
        MetaTable table = (MetaTable)dataObj.getTableCollection().get(tableKey);
        if (table == null) {
            throw new RuntimeException("\u5b57\u5178[" + itemKey + "]\u4e2d\u4e0d\u5b58\u5728\u8868[" + tableKey + "]");
        }
        if (!table.containsKey(colKey)) {
            throw new RuntimeException("\u5b57\u5178[" + itemKey + "]\u7684\u8868[" + tableKey + "]\u4e2d\u4e0d\u5b58\u5728\u5217[" + colKey + "]");
        }
        Item item = dictCache.getItem(itemKey, oid, 7);
        if (item != null) {
            value = item.impl_getValue(tableKey, colKey);
        }
        return value;
    }

    public static boolean isIgnoreRights(VE ve, String formKey, String fieldKey) throws Throwable {
        MetaDictProperties properties = MetaUtil.getDictProperties((IMetaFactory)ve.getMetaFactory(), (String)formKey, (String)fieldKey);
        Boolean ignoreRights = false;
        if (properties != null) {
            ignoreRights = properties.isIgnoreRights();
        } else if (formKey != null && !formKey.isEmpty()) {
            MetaForm metaForm = ve.getMetaFactory().getMetaForm(formKey);
            MetaComponent meta = metaForm.componentByKey(fieldKey);
            if (meta != null && meta.getControlType() == 206) {
                ignoreRights = ((MetaDict)meta).isIgnoreRights();
            } else if (meta != null && meta.getControlType() == 303) {
                ignoreRights = ((MetaDictPane)meta).isIgnoreRights();
            } else if (meta != null && meta.getControlType() == 304) {
                ignoreRights = ((MetaDictSearchBox)meta).isIgnoreRights();
            }
        }
        return ignoreRights;
    }
}

