/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.datatable;

import com.bokesoft.yes.common.util.LockUtil;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.datatable.IndexRow;
import com.bokesoft.yigo.struct.datatable.IndexValue;
import com.bokesoft.yigo.struct.datatable.IntList;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class Index {
    final String[] fieldArray;
    private int[] fieldIndexes;
    private int[] fieldDataTypes;
    private final DataTable rst;
    private Map<IndexValue, List<IndexRow>> indexRows;
    private Map<Integer, IndexValue> bookmarkToIndexValues;
    private HashSet<Integer> updateBookmarks;
    private List<Integer> insertBookmarks;
    private List<Row> deleteRows;

    public Index(DataTable rst, String[] fieldArray) {
        this.rst = rst;
        this.fieldArray = fieldArray;
        this.initFieldIndexes();
    }

    private void initFieldIndexes() {
        int count = this.fieldArray.length;
        this.fieldIndexes = new int[count];
        this.fieldDataTypes = new int[count];
        DataTableMetaData metaData = this.rst.getMetaData();
        for (int i = 0; i < count; ++i) {
            ColumnInfo columnInfo = metaData.getColumnInfo(this.fieldArray[i]);
            this.fieldIndexes[i] = columnInfo.getColumnIndex();
            this.fieldDataTypes[i] = columnInfo.getDataType();
        }
    }

    public boolean isSatisfy(String[] filterColumns) {
        int length = filterColumns.length;
        if (this.fieldArray.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.fieldArray[i].equalsIgnoreCase(filterColumns[i])) continue;
            return false;
        }
        return true;
    }

    private IndexValue newIndexValue(int bookmark, Object[] indexValues, int[] fieldDataTypes) {
        IndexValue result = new IndexValue(indexValues, fieldDataTypes);
        if (this.bookmarkToIndexValues == null) {
            this.bookmarkToIndexValues = new HashMap<Integer, IndexValue>();
        }
        this.bookmarkToIndexValues.put(bookmark, result);
        return result;
    }

    private void initCache() throws Throwable {
        if (this.indexRows == null) {
            int size = this.rst.size();
            ConcurrentHashMap<IndexValue, List<IndexRow>> data = new ConcurrentHashMap<IndexValue, List<IndexRow>>(size);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                int bookmark = this.rst.getBookmark(rowIndex);
                Object[] indexValues = this.getIndexValues(rowIndex);
                IndexValue key = this.newIndexValue(bookmark, indexValues, this.fieldDataTypes);
                IndexRow indexRow = new IndexRow(rowIndex, bookmark);
                CopyOnWriteArrayList<IndexRow> rows = (CopyOnWriteArrayList<IndexRow>)data.get(key);
                if (rows == null) {
                    rows = new CopyOnWriteArrayList<IndexRow>();
                    data.put(key, rows);
                }
                if (rows.contains(indexRow)) continue;
                rows.add(indexRow);
            }
            this.indexRows = data;
        } else if (this.updateBookmarks != null || this.insertBookmarks != null || this.deleteRows != null) {
            this.updateIndexRows();
            this.updateBookmarks = null;
            this.insertBookmarks = null;
            this.deleteRows = null;
        }
    }

    private Object[] getIndexValues(int rowIndex) {
        Object[] dataList = this.rst.getRowByIndex(rowIndex).getDataList();
        int fieldCount = this.fieldIndexes.length;
        Object[] result = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            Object value = dataList[this.fieldIndexes[i]];
            result[i] = Index.convertType(value, this.fieldDataTypes[i]);
        }
        return result;
    }

    public static Object convertType(Object value, int fieldDataType) {
        switch (fieldDataType) {
            case 1010: {
                return TypeConvertor.toLong((Object)value);
            }
            case 1001: 
            case 1009: {
                return TypeConvertor.toInteger((Object)value);
            }
            case 1005: {
                return TypeConvertor.toBigDecimal((Object)value);
            }
            case 1002: 
            case 1012: {
                return TypeConvertor.toString((Object)value);
            }
        }
        throw new RuntimeException("DataTable\u7d22\u5f15\u4e0d\u652f\u6301\u7c7b\u578b\uff1a" + fieldDataType + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002");
    }

    public void clear() {
        if (this.indexRows != null) {
            this.indexRows.clear();
        }
        this.indexRows = null;
    }

    public int[] filter(Object[] filterValues) throws Throwable {
        LockUtil.execute((String)("Index.InitCache." + this.hashCode()), () -> {
            this.initCache();
            return null;
        });
        return this.filter_impl(filterValues);
    }

    private int[] filter_impl(Object[] filterValues) throws Throwable {
        int columnSize = filterValues.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue = filterValues[i];
            if (!filterValue.getClass().isArray()) continue;
            int valueCount = Array.getLength(filterValue);
            Object[][] newFilterValues = new Object[valueCount][columnSize];
            for (int j = 0; j < valueCount; ++j) {
                for (int k = 0; k < columnSize; ++k) {
                    newFilterValues[j][k] = k == i ? Array.get(filterValue, j) : filterValues[k];
                }
            }
            IntList intList = new IntList(Integer.min(this.rst.size(), 64));
            for (int j = 0; j < valueCount; ++j) {
                intList.add(this.filter_impl(newFilterValues[j]));
            }
            return intList.toArray();
        }
        return this.filter_implNoArray(filterValues);
    }

    private int[] filter_implNoArray(Object[] filterValues) throws Throwable {
        IndexValue key = new IndexValue(filterValues, this.fieldDataTypes);
        List<IndexRow> resultRows = this.indexRows.get(key);
        if (resultRows == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int resultSize = resultRows.size();
        int[] result = new int[resultSize];
        int rstSize = this.rst.size();
        for (int i = 0; i < resultSize; ++i) {
            IndexRow indexRow = resultRows.get(i);
            int rowIndexTmp = indexRow.rowIndex;
            if (rowIndexTmp >= rstSize || this.rst.getBookmark(rowIndexTmp) != indexRow.bookmark) {
                indexRow.rowIndex = rowIndexTmp = this.rst.getRowIndexByBookmark(indexRow.bookmark);
            }
            result[i] = rowIndexTmp;
        }
        return result;
    }

    public Object[][] getDistinctKeyValues() throws Throwable {
        LockUtil.execute((String)("Index.InitCache." + this.hashCode()), () -> {
            this.initCache();
            return null;
        });
        int fieldCount = this.fieldArray.length;
        int size = this.indexRows.size();
        Object[][] result = new Object[size][fieldCount];
        int index = 0;
        for (IndexValue indexValue : this.indexRows.keySet()) {
            System.arraycopy(indexValue.indexValues, 0, result[index], 0, fieldCount);
            ++index;
        }
        return result;
    }

    public void updateIndex(HashSet<Integer> updateBookmarks, List<Integer> insertBookmarks, List<Row> deleteRows) {
        if (this.indexRows == null) {
            return;
        }
        if (updateBookmarks != null) {
            if (this.updateBookmarks == null) {
                this.updateBookmarks = new HashSet<Integer>(updateBookmarks);
            } else {
                this.updateBookmarks.addAll(updateBookmarks);
            }
        }
        if (insertBookmarks != null) {
            if (this.insertBookmarks == null) {
                this.insertBookmarks = new CopyOnWriteArrayList<Integer>(insertBookmarks);
            } else {
                this.insertBookmarks.addAll(insertBookmarks);
            }
        }
        if (deleteRows != null) {
            if (this.deleteRows == null) {
                this.deleteRows = new CopyOnWriteArrayList<Row>(deleteRows);
            } else {
                this.deleteRows.addAll(deleteRows);
            }
        }
    }

    private void updateIndexRows() {
        if (this.deleteRows != null) {
            for (Row row : this.deleteRows) {
                int index;
                if (this.insertBookmarks != null && (index = this.insertBookmarks.indexOf(row.getBookmark())) >= 0) {
                    this.insertBookmarks.remove(index);
                    continue;
                }
                this.deleteRow(row);
            }
        }
        if (this.insertBookmarks != null) {
            Iterator<Serializable> iterator = this.insertBookmarks.iterator();
            while (iterator.hasNext()) {
                int bookmark = (Integer)iterator.next();
                this.insertRow(bookmark);
            }
        }
        if (this.updateBookmarks != null) {
            for (Integer bookmark : this.updateBookmarks) {
                this.updateRow(bookmark);
            }
        }
    }

    private void deleteRow(Row row) {
        int deleteBookmark = row.getBookmark();
        this.deleteRowByBookmark(deleteBookmark);
    }

    private void deleteRowByBookmark(int deleteBookmark) {
        IndexValue key = this.bookmarkToIndexValues.get(deleteBookmark);
        List<IndexRow> rows = this.indexRows.get(key);
        int length = rows.size();
        if (length == 1) {
            this.indexRows.remove(key);
        } else {
            for (int i = length - 1; i >= 0; --i) {
                IndexRow indexRow = rows.get(i);
                if (indexRow.bookmark != deleteBookmark) continue;
                rows.remove(i);
                break;
            }
        }
    }

    private void insertRow(int bookmark) {
        int rowIndex = this.rst.getRowIndexByBookmark(bookmark);
        Object[] indexValues = this.getIndexValues(rowIndex);
        IndexValue key = this.newIndexValue(bookmark, indexValues, this.fieldDataTypes);
        IndexRow indexRow = new IndexRow(rowIndex, bookmark);
        List<IndexRow> rows = this.indexRows.get(key);
        if (rows == null) {
            rows = new CopyOnWriteArrayList<IndexRow>();
            this.indexRows.put(key, rows);
        }
        if (!rows.contains(indexRow)) {
            rows.add(indexRow);
        }
    }

    private void updateRow(int bookmark) {
        int rowIndex = this.rst.getRowIndexByBookmark(bookmark);
        if (rowIndex < 0) {
            return;
        }
        Object[] indexValues = this.getIndexValues(rowIndex);
        IndexValue oldIndexValue = this.bookmarkToIndexValues.get(bookmark);
        if (!IndexValue.isSame(indexValues, oldIndexValue.indexValues)) {
            this.deleteRowByBookmark(bookmark);
            IndexValue key = this.newIndexValue(bookmark, indexValues, this.fieldDataTypes);
            IndexRow indexRow = new IndexRow(rowIndex, bookmark);
            List<IndexRow> rows = this.indexRows.get(key);
            if (rows == null) {
                rows = new CopyOnWriteArrayList<IndexRow>();
                this.indexRows.put(key, rows);
            }
            if (!rows.contains(indexRow)) {
                rows.add(indexRow);
            }
        }
    }
}

