/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.datatable;

import com.bokesoft.yes.common.struct.HashMapIgnoreCaseFastGet;
import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class DataTableMetaData
implements Externalizable,
IJSONHandler {
    private Vector<ColumnInfo> tableColumns = new Vector();
    private HashMapIgnoreCaseFastGet<ColumnInfo> tableColumnMap = new HashMapIgnoreCaseFastGet();
    private ColumnInfo tempColumnInfo = null;

    public void addColumn(ColumnInfo column) throws StructException {
        this.addColumn(this.tableColumns.size(), column);
    }

    public boolean constains(String key) {
        return this.tableColumnMap.containsKey(key);
    }

    public void addColumn(int index, ColumnInfo column) throws StructException {
        String columnKey = column.getColumnKey();
        if (this.tableColumnMap.get(columnKey) != null) {
            throw new StructException(4, StructException.formatMessage(null, 4, new Object[0]) + ",\u5217" + columnKey + "\u5df2\u7ecf\u6dfb\u52a0,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        column.setColumnIndex(index);
        this.tableColumns.add(index, column);
        this.tableColumnMap.put(column.getColumnKey(), (Object)column);
        while (index < this.tableColumns.size() - 1) {
            this.tableColumns.get(++index).setColumnIndex(index);
        }
    }

    public void removeColumn(String columnKey) {
        int index;
        ColumnInfo column = (ColumnInfo)this.tableColumnMap.remove(columnKey);
        if (column == null) {
            return;
        }
        this.tableColumns.remove(index);
        for (index = column.getColumnIndex(); index < this.tableColumns.size(); ++index) {
            this.tableColumns.get(index).setColumnIndex(index);
        }
    }

    void clear() {
        this.tableColumns.clear();
        this.tableColumnMap.clear();
    }

    public int findColumnIndexByKey(String columnKey) {
        return this.findColumnIndexByKey(columnKey, false);
    }

    public int findColumnIndexByKey(String columnKey, boolean throwErr) {
        ColumnInfo column = (ColumnInfo)this.tableColumnMap.get(columnKey);
        if (column != null) {
            return column.getColumnIndex();
        }
        if (throwErr) {
            throw new StructException(6, StructException.formatMessage(null, 6, columnKey));
        }
        return -1;
    }

    public int impl_findColumnIndexByKey(String columnKey) {
        return this.impl_findColumnIndexByKey(columnKey, false);
    }

    public int impl_findColumnIndexByKey(String columnKey, boolean throwErr) {
        ColumnInfo column = (ColumnInfo)this.tableColumnMap.get(columnKey);
        if (column != null) {
            return column.getColumnIndex();
        }
        if (throwErr) {
            throw new StructException(6, StructException.formatMessage(null, 6, columnKey));
        }
        return -1;
    }

    public ColumnInfo getColumnInfo(String columnKey) throws StructException {
        ColumnInfo column = (ColumnInfo)this.tableColumnMap.get(columnKey);
        if (column != null) {
            return column;
        }
        throw new StructException(4, StructException.formatMessage(null, 4, new Object[0]) + ",\u5217" + columnKey + "\u4e0d\u5b58\u5728\uff01");
    }

    public ColumnInfo getColumnInfo(int index) {
        return this.tableColumns.elementAt(index);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public DataTableMetaData deepClone() {
        DataTableMetaData clone = new DataTableMetaData();
        for (ColumnInfo c : this.tableColumns) {
            clone.tableColumns.add(c.deepClone());
        }
        clone.tableColumnMap.putAll(this.tableColumnMap);
        return clone;
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public IJSONHandler newHandler(String token) {
        this.tempColumnInfo = new ColumnInfo();
        return this.tempColumnInfo;
    }

    @Override
    public void putAttr(String name, String value) {
    }

    @Override
    public void endHandler() {
    }

    @Override
    public void endChildHandler(IJSONHandler handler) {
        int index = this.tableColumns.size();
        this.tableColumns.add(this.tempColumnInfo);
        this.tempColumnInfo.setColumnIndex(index);
        this.tableColumnMap.put(this.tempColumnInfo.getColumnKey(), (Object)this.tempColumnInfo);
        this.tempColumnInfo = null;
    }
}

