/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.struct.document;

public class JSONTokenizer {
    public static final int L_BR = 0;
    public static final int R_BR = 1;
    public static final int L_MB = 2;
    public static final int R_MB = 3;
    public static final int STRING = 4;
    public static final int VALUE = 5;
    public static final int COMMA = 6;
    public static final int COLON = 7;
    private String s = "";
    private int start = 0;
    private int l = 0;
    private int pos = 0;
    private int err = 0;
    private String token = "";

    public JSONTokenizer(String s) {
        this.s = s;
        this.l = s.length();
    }

    private char skipBlank(char c) {
        char result = c;
        this.err = 0;
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            if (this.pos >= this.l) {
                this.err = -1;
                return result;
            }
            c = this.s.charAt(this.pos);
            result = c;
            ++this.pos;
            ++this.start;
        }
        return result;
    }

    public int next() {
        int id = -1;
        this.start = this.pos;
        if (this.pos >= this.l) {
            return -1;
        }
        char c = this.s.charAt(this.pos);
        ++this.pos;
        c = this.skipBlank(c);
        if (this.err == -1) {
            return -1;
        }
        int cnt = 1;
        switch (c) {
            case '{': {
                id = 0;
                this.token = "{";
                break;
            }
            case '}': {
                id = 1;
                this.token = "}";
                break;
            }
            case '[': {
                id = 2;
                this.token = "[";
                break;
            }
            case ']': {
                id = 3;
                this.token = "]";
                break;
            }
            case ',': {
                id = 6;
                this.token = ",";
                break;
            }
            case ':': {
                id = 7;
                this.token = ":";
                break;
            }
            case '\"': {
                boolean escaped = false;
                do {
                    if (this.pos < this.l) {
                        c = this.s.charAt(this.pos);
                        ++this.pos;
                        ++cnt;
                    } else {
                        this.err = 1;
                        return -1;
                    }
                    if (c == '\\') {
                        escaped = true;
                        continue;
                    }
                    if (!escaped || c == '\"') continue;
                    escaped = false;
                } while (c != '\"' || escaped);
                id = 4;
                this.token = this.s.substring(this.start + 1, this.start + cnt - 1);
                break;
            }
            default: {
                if (this.pos < this.l) {
                    c = this.s.charAt(this.pos);
                    while (c != ' ' && c != '\t' && c != '\n' && c != '\r' && c != '{' && c != '}' && c != '[' && c != ']' && c != ',' && c != ':') {
                        ++cnt;
                        ++this.pos;
                        if (this.pos >= this.l) break;
                        c = this.s.charAt(this.pos);
                    }
                }
                id = 5;
                this.token = this.s.substring(this.start, this.start + cnt);
            }
        }
        return id;
    }

    public String getToken() {
        return this.token;
    }
}

