package com.bokesoft.yigo.struct.variant;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;
/**
 * 变体条目,包含值和处理方式
 * 
 * @author 陈瑞
 * @see Variant
 *
 */
public class VariantItem implements JSONSerializable {
	/** 值的处理方式*/
	private int option = -1;
	private List<String> values; // 替换或者追加
	
	public VariantItem(int option) {
		super();
		this.option = option;
		this.values = new ArrayList<String>();
	}
	
	public VariantItem(JSONObject o) {
		try {
			fromJSON(o);
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	public void addValue(String value) {
		values.add(value);
	}
	
	public void setValue(int index,String value) {
		values.set(index, value);
	}
	
	public int size() {
		return values.size();
	}
	
	public String getValue(int index) {
		return values.get(index);
	}
	
	public List<String> getValues() {
		return values;
	}
	
	public void clear() {
		this.values.clear();
	}
	
	public int getOption() {
		return option;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject o = new JSONObject();
		o.put("option", option);
		
		JSONArray values = new JSONArray();
		for( String value : this.values ) {
			values.put(value);
		}
		
		o.put("values", values);
		return o;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) {
		this.option = jsonObj.optInt("option");
		
		this.values = new ArrayList<>();
		JSONArray arr = new JSONArray(jsonObj.optString("values"));
		for( int i = 0,size = arr.length();i < size;i++ ) {
			this.values.add(arr.optString(i));
		}
	}

}
