package com.bokesoft.yigo.struct.state;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

/**
 * ViewState定义客户端的界面状态
 * @author wangyh
 *
 */
public class ViewState implements JSONSerializable {
	/** 集合组件状态集合 */
	private ArrayList<SetComponentState> setStates = null;
	
	/**
	 * 增加状态
	 * @param state 状态
	 */
	public void addSetState(SetComponentState state) {
		if ( setStates == null ) {
			setStates = new ArrayList<SetComponentState>();
		}
	}
	
	/**
	 * 取得集合组件数量
	 * @return 数量
	 */
	public int getSetCount() {
		return setStates != null ? setStates.size() : 0;
	}
	
	/**
	 * 取得指定位置的集合组件状态
	 * @param index 序号
	 * @return index所在位置的集合组件状态
	 */
	public SetComponentState getSetState(int index) {
		return this.setStates.get(index);
	}

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		if ( setStates != null ) {
			JSONArray setArray = new JSONArray();
			for ( int i = 0, size = setStates.size(); i<size; ++i ) {
				SetComponentState setState = setStates.get(i);
				JSONObject setJSON = setState.toJSON();
				setArray.put(setJSON);
			}
			json.put("set", setArray);
		}
		return json;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		JSONArray setArray = jsonObj.optJSONArray("set");
		if ( setArray != null ) {
			int size = setArray.length();
			if ( size > 0 ) {
				setStates = new ArrayList<SetComponentState>();
				for ( int i = 0; i<size; ++i ) {
					JSONObject setJSON = setArray.getJSONObject(i);
					SetComponentState setState = new SetComponentState();
					setState.fromJSON(setJSON);
					setStates.add(setState);
				}
			}
		}
	}
}
