package com.bokesoft.yigo.struct.headinfo;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class HeadInfos {
	/** 记录一次性HeadInfo*/
	private ConcurrentHashMap<String, Object> currentHeadInfos = null;
	
	/** 记录全局性的headInfo*/
	private ConcurrentHashMap<String, Object> globalHeadInfos = null;
	
	public HeadInfos() {
		this.currentHeadInfos = new ConcurrentHashMap<String, Object>();
		this.globalHeadInfos = new ConcurrentHashMap<String, Object>();
	}

	public void putHeadInfo(String key, Object value, boolean global) {
		if (global) {
			this.globalHeadInfos.put(key, value);
		} else {
			this.currentHeadInfos.put(key, value);
		}
	}

	public Object getHeadInfo (String key, boolean global) {
		Object value = null;
		if (global) {
			value = this.globalHeadInfos.get(key);
		} else {
			value = this.currentHeadInfos.get(key);
		}
		
		return value;
	}

	public Object removeHeadInfo (String key, boolean global) {
		Object value = null;
		if (global) {
			value = this.globalHeadInfos.remove(key);
		} else {
			value = this.currentHeadInfos.remove(key);
		}
		return value;
	}
	
	public void clearCurrentHeadInfo () {
		this.currentHeadInfos.clear();
	}
	
	public HashMap<String, Object> getHeadInfos() {
		HashMap<String, Object> headInfos = new HashMap<String, Object>();
		if (this.currentHeadInfos != null) {
			headInfos.putAll(currentHeadInfos);
		}
		
		if (this.globalHeadInfos != null) {
			headInfos.putAll(globalHeadInfos);
		}

		return headInfos;
	}
}
