package com.bokesoft.yigo.struct.expand;

import java.util.List;

/**
 * 扩展表定义
 * @author chenbb
 *
 * @param <S> 扩展源字段
 * @param <F> 扩展维度字段
 */
public interface IExpandTableDefine<S extends IExpandSourceField<F>, F extends IExpandDimensionField> {
	
	/**
	 * 获取固定字段列表
	 * @return
	 */
	public List<String> getFixedFieldKeys();
	
	/**
	 * 获取扩展字段列表
	 * @return
	 */
	public List<S> getExpandFields();
	
	/**
	 * 获取扩展源字段对应的维度字段
	 * @param expandFieldKey
	 * @return
	 */
	//public List<F> getDimensionFields(String expandFieldKey);
	
	public F getDimensionField(String key);
	
}
