package com.bokesoft.yigo.struct.expand;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;

public abstract class AbstractExpandMaster<S extends IExpandSourceField<F>, F extends IExpandDimensionField> {

	private ArrayList<IExpandWork<S, F>> expandWorks = new ArrayList<>();
	
	public void addExpandWork(IExpandWork<S, F> expandWork) {
		this.expandWorks.add(expandWork);
	}
	
	public void doWorks(List<String> fixedFieldKeys, List<DimensionItem<IPairItem, S, F>> colRootDimensionItems,
			List<DimensionItem<IPairItem, S, F>> rowRootDimensionItems) {
		for (IExpandWork<S, F> work : expandWorks) {
			work.doWork(fixedFieldKeys, colRootDimensionItems, rowRootDimensionItems);
		}
	}
	
	public void clearWorks() {
		this.expandWorks.clear();
	}
}
