package com.bokesoft.yigo.struct.env;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.struct.headinfo.HeadInfos;

public class Env implements ILocale {
	/** 数据簇标识 */
	private long clusterID = -1;
	/** 客户端标识 */
	private String clientID = null;
	/** 用户代码 */
	private String userCode = null;
	/** 用户名称 */
	private String userName = null;
	/** 用户标识 */
	private long userID = -1;
	/** 游客标识 */
	private long guestUserID = -1;
	/** 主机地址 */
	private String host = null;
	/** 主机端口 */
	private String port = null;
	/** 客户端ip地址 */
	private String clientIP = "";
	/** 登录模式 */
	private int mode = -1;
	/** 本地化标识 */
	private String locale = "";
	/** 语言 */
	private String language = "";
	/** 国家 */
	private String country = "";
	/** 时区 */
	private String timeZone = "";
	/** 会话级参数集合 */
	private Map<String, Object> sessionParas = null;

	private int operatingEnvironment = AppRunType.App;
	/** temp会话级参数集合,为同步至客户端使用 */
	private Map<String, Object> tempSessionParas = null;
	/** Cookie，只用于处理javafx应用程序的Cookie */
	private List<String> cookies = null;
	/** 客户端临时clientid */
	private String tmpClientID = "";

	/** 每次返回请求的ticketid,安全的等级为2时使用 */
	private int ticketID = 0;

	/** 控制系统是否需要做指纹检查, 服务端也会有独立的是否需要检查指纹控制  , 安全等级为4时启用 */
	private boolean needCheckFingprint = false;

	/** 用户操作信息*/
	private HeadInfos headInfos = null;

	/** 项目名 */
	private String contextName = "";

	/** 关联角色ID集合 */
	private List<Long> roleIDList = null;

	/**　是否登录　*/
	private boolean isAuthenticated = false;

	public Env(){
		this.headInfos = new HeadInfos();
	}

	public Env(String host, String port){
		this.host = host;
		this.port = port;
		this.headInfos = new HeadInfos();
	}

	public int getMode() {
		return mode;
	}

	public void setMode(int mode) {
		this.mode = mode;
	}

	private String time = null;
	public String getTime() {
		return time;
	}
	public void setTime(String time) {
		this.time = time;
	}

	public int getOperatingEnvironment() {
		return operatingEnvironment;
	}

	public void setOperatingEnvironment(int operatingEnvironment) {
		this.operatingEnvironment = operatingEnvironment;
	}

	public void setClientID(String clientID) {
		this.clientID = clientID;
	}

	public String getClientID() {
		return this.clientID;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public String getUserCode() {
		return this.userCode;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserName() {
		return this.userName;
	}

	public void setUserID(Long userID) {
		this.userID = userID;
	}

	public Long getUserID() {
		return this.userID;
	}

	/**
	 * 设置游客用户
	 * @param guestUserID 游客用户
	 */
	public void setGuestUserID(long guestUserID) {
		this.guestUserID = guestUserID;
	}

	/**
	 * 取得游客用户
	 * @return 游客用户
	 */
	public long getGuestUserID() {
		return this.guestUserID;
	}

	public long getClusterid() {
		return clusterID;
	}

	public void setClusterid(long clusterid) {
		this.clusterID = clusterid;
	}

	private void setHost(String host) {
		this.host = host;
	}

	public String getHost() {
		return this.host;
	}

	private void setPort(String port) {
		this.port = port;
	}

	public String getPort() {
		return this.port;
	}

	/**
	 * 设置语言
	 * @param language 语言
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	/**
	 * 取得语言
	 * @return 语言
	 */
	public String getLanguage() {
		return this.language;
	}

	/**
	 * 设置国家
	 * @param country 国家
	 */
	public void setCountry(String country) {
		this.country = country;
	}

	/**
	 * 取得国家
	 * @return 国家
	 */
	public String getCountry() {
		return this.country;
	}

	/**
	 * 设置时区
	 * @param timeZone 时区
	 */
	public void setTimeZone(String timeZone) {
		this.timeZone = timeZone;
	}

	/**
	 * 取得时区
	 * @return 时区
	 */
	public String getTimeZone() {
		return this.timeZone;
	}

	/**
	 * 设置本地化标识
	 * @param locale 本地化标识
	 */
	public void setLocale(String locale) {
		this.locale = locale;
	}

	@Override
	public String getLocale() {
		return this.locale;
	}

	/**
	 * 设置客户端IP地址
	 * @param clientIP 客户端IP地址
	 */
	public void setClientIP(String clientIP) {
		this.clientIP = clientIP;
	}

	/**
	 * 取得客户端IP地址
	 * @return IP地址
	 */
	public String getClientIP() {
		return this.clientIP;
	}

	/**
	 * 增加参数
	 * @param key 参数标识
	 * @param value 参数值
	 */
	public void put(String key, Object value) {
		if ( this.sessionParas == null ) {
			this.sessionParas = new HashMap<String, Object>();
		}
		if ( this.tempSessionParas == null ) {
			this.tempSessionParas = new HashMap<String, Object>();
		}
		this.sessionParas.put(key, value);
		this.tempSessionParas.put(key, value);
	}/**
	 * 增加参数
	 * @param key 参数标识
	 * @param value 参数值
	 */
	public void putSeesionPara(String key, Object value) {
		if ( this.sessionParas == null ) {
			this.sessionParas = new HashMap<String, Object>();
		}
		if ( this.tempSessionParas == null ) {
			this.tempSessionParas = new HashMap<String, Object>();
		}
		this.sessionParas.put(key, value);
		this.tempSessionParas.put(key, value);
	}
	/**
	 * 删除参数
	 * @param key 参数标识
	 * @param value 参数值
	 */
	public void remove(String key, Object value) {
		if ( this.sessionParas == null ) {
			return;
		}
		if ( this.tempSessionParas == null ) {
			this.tempSessionParas = new HashMap<String, Object>();
		}
		this.sessionParas.remove(key);
		this.tempSessionParas.remove(key);
		tempSessionParas.put("RemoveItem",key);
	}
	/**
	 * 删除参数
	 * @param key 参数标识
	 * @param value 参数值
	 */
	public void removeSeesionPara(String key ) {
		if ( this.sessionParas == null ) {
			return;
		}
		if ( this.tempSessionParas == null ) {
			this.tempSessionParas = new HashMap<String, Object>();
		}
		this.sessionParas.remove(key);
		this.tempSessionParas.remove(key);
		tempSessionParas.put("RemoveItem",key);
	}

	public void clearTempSession() {
		if (tempSessionParas!=null){
			this.tempSessionParas.clear();
		}
	}

	public Map<String, Object> getTempSessionPara() {
		if (tempSessionParas!=null){
			return this.tempSessionParas;
		}else {
			return  new HashMap<>();
		}
	}

	/**
	 * 取得参数的值
	 * @param key 参数标识
	 * @return 参数值
	 */
	public Object get(String key) {
		return this.sessionParas != null ? this.sessionParas.get(key) : null;
	}

	public void setSessionParas(Map<String, Object> sessionParas) {
		this.sessionParas = sessionParas;
	}

	public Map<String, Object> getSessionParas() {
		return sessionParas;
	}

	/**
	 * 设置Cookie
	 * @param cookies Cookie列表
	 */
	public void setCookies(List<String> cookies) {
		this.cookies = cookies;
	}

	/**
	 * 添加cookie
	 * @param cookies
	 */
	public void addCookies(List<String> cookies) {
		if(this.cookies == null) {
			this.cookies = new ArrayList<String>();
		}

		String k1, k2, s2;
		int index = -1;
		Iterator<String> it;
		for(String s :  cookies) {
			index = s.indexOf('=');
			k1 = s.substring(0, index);

			it= this.cookies.iterator();
			while(it.hasNext()) {
				s2 = it.next();
				index = s2.indexOf('=');
				k2 = s2.substring(0, index);
				if(k1.equals(k2)) {
					it.remove();
				}
			}
			this.cookies.add(s);
		}
	}

	/**
	 * 取得Cookie
	 * @return Cookie列表
	 */
	public List<String> getCookies() {
		return this.cookies;
	}

	public void setTempClientID(String tmpClientID) {
		this.tmpClientID = tmpClientID;
	}

	public String getTempClientID() {
		return this.tmpClientID;
	}

	public void setTicketID(int ticketid) {
		this.ticketID = ticketid;
	}

	public int getTicketID() {
		return this.ticketID;
	}

	public void setNeedCheckfingerprint(boolean b) {
		this.needCheckFingprint = b;
	}

	public boolean isNeedCheckFingerprint() {
		return this.needCheckFingprint;
	}

	/**
	 * 获取headInfo值
	 *
	 */
	public Object getHeadInfo(String key) {
		return getHeadInfo(key, false);
	}

	public Object getHeadInfo(String key, boolean global) {
		return this.headInfos.getHeadInfo(key, global);
	}

	/**
	 * 设置headInfo值
	 *
	 */
	public void putHeadInfo(String key, Object value) {
		putHeadInfo(key, value, false);
	}

	public void putHeadInfo(String key, Object value, boolean global) {
		this.headInfos.putHeadInfo(key, value, global);
	}

	/**
	 * 设置项目名
	 * @param contextName 项目名
	 */
	public void setContextName(String contextName){
		this.contextName = contextName;
	}

	/**
	 * 获取项目名
	 * @return 项目名
	 */
	public String getContextName(){
		return this.contextName;
	}
	/**
	 * 移除HeadInfo
	 *
	 */
	public Object removeHeadInfo(String key) {
		return removeHeadInfo(key, false);
	}

	public Object removeHeadInfo(String key, boolean global) {
		return this.headInfos.removeHeadInfo(key, global);
	}

	public void clearCurrentHeadInfo() {
		this.headInfos.clearCurrentHeadInfo();
	}

	public Map<String, Object> getHeadInfos() {
		return this.headInfos.getHeadInfos();
	}

	public void setHeadInfos(HeadInfos headInfos) {
		this.headInfos = headInfos;
	}

	public List<Long> getRoleIDList() {
		return roleIDList;
	}

	public void setRoleIDList(List<Long> roleIDList) {
		this.roleIDList = roleIDList;
	}

	public void setAuthenticated(boolean b) {
		this.isAuthenticated = b;
	}

	public boolean isAuthenticated() {
		return this.isAuthenticated;
	}
	/**
	 * 复制一个Env
	 */
	public Env clone(){
		Env clone = new Env();
		clone.setClientID(clientID);
		clone.setClientIP(clientIP);
		clone.setClusterid(clusterID);
		clone.setCountry(country);
		clone.setHost(host);
		clone.setLanguage(language);
		clone.setLocale(locale);
		clone.setMode(mode);
		clone.setPort(port);
		clone.setTime(time);
		clone.setTimeZone(timeZone);
		clone.setUserCode(userCode);
		clone.setUserID(userID);
		clone.setGuestUserID(guestUserID);
		clone.setUserName(userName);
		clone.setTempClientID(tmpClientID);
		clone.setTicketID(ticketID);
		clone.setNeedCheckfingerprint(needCheckFingprint);
		clone.setHeadInfos(headInfos);
		clone.setContextName(contextName);
		clone.setRoleIDList(roleIDList);
		clone.setCookies(cookies);
		clone.setAuthenticated(isAuthenticated);

		if ( this.sessionParas != null ) {
			Iterator<Entry<String, Object>> it = this.sessionParas.entrySet().iterator();
			Entry<String, Object> entry = null;
			while ( it.hasNext() ) {
				entry = it.next();
				clone.put(entry.getKey(), entry.getValue());
			}
		}

		return clone;
	}

}
