package com.bokesoft.yigo.struct.document.track;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 一个数据文档的执行轨迹
 * 
 * @author 刘翔翔
 *
 */
public class DocumentTrack {

	/** 轨迹数据 */
	private Map<String, TrackDetail> trackDetailMap = new LinkedHashMap<>();

	/**
	 * 添加一个轨迹
	 * 
	 * @param type
	 *            类型
	 * @param info
	 *            参数
	 */
	public void addTrack(int type, String info) {
		trackDetailMap.putIfAbsent(type + info, new TrackDetail(type, info));
	}

	/**
	 * 查询当前数据文档的轨迹中是否有符合条件的步骤
	 * 
	 * @param type
	 *            类型
	 * @param info
	 *            参数
	 * @return 如果包括则返回true，否则返回false
	 */
	public boolean contains(int type, String info) {
		TrackDetail trackDetail = trackDetailMap.get(type + info);
		return trackDetail != null;
	}
	
	/**
	 * 移除一个轨迹
	 * @param type
	 * @param info
	 */
	public void remove(int type, String info) {
		trackDetailMap.remove(type + info);
	}
}
