/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.expand.work;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.expand.IExpandDimensionField;
import com.bokesoft.yigo.struct.expand.IExpandSourceField;
import com.bokesoft.yigo.struct.expand.IExpandWork;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTableExpandWork<S extends IExpandSourceField<F>, F extends IExpandDimensionField>
implements IExpandWork<S, F> {
    private Document document = null;
    private DataTable baseDataTable = null;

    public DataTableExpandWork(DataTable baseDataTable, Document document) {
        this.document = document;
        this.baseDataTable = baseDataTable;
    }

    @Override
    public void doWork(List<String> fixedFieldKeys, List<DimensionItem<IPairItem, S, F>> colRootDimensionItems, List<DimensionItem<IPairItem, S, F>> rowRootDimensionItems) {
        String targetKey = this.getExpandTargetKey(this.baseDataTable.getKey());
        DataTable targetDataTable = this.createTargetTableStruct(colRootDimensionItems, fixedFieldKeys, targetKey, this.baseDataTable);
        this.fillExpandData(this.baseDataTable, fixedFieldKeys, colRootDimensionItems, targetDataTable);
        this.document.remove(targetKey);
        this.document.add(targetKey, targetDataTable);
    }

    private void fillExpandData(DataTable sourceDataTable, List<String> fixedFieldKeys, List<DimensionItem<IPairItem, S, F>> colRootDimensionItems, DataTable targetDataTable) {
        HashMap<String, Object> fixedValues = new HashMap<String, Object>();
        this.initFixedValues(fixedValues, fixedFieldKeys);
        String fixValuesKey = null;
        HashMap<String, Integer> recorder = new HashMap<String, Integer>();
        sourceDataTable.beforeFirst();
        while (sourceDataTable.next()) {
            if (this.isFixedValueChanged(fixedValues, sourceDataTable)) {
                fixValuesKey = this.getFixValuesKey(fixedFieldKeys, sourceDataTable);
                if (recorder.containsKey(fixValuesKey)) {
                    int rowIndex = (Integer)recorder.get(fixValuesKey);
                    targetDataTable.setPos(rowIndex);
                } else {
                    Object fixedValue = null;
                    int rowIndex = targetDataTable.append();
                    for (String fixedFieldKey : fixedFieldKeys) {
                        fixedValue = sourceDataTable.getObject(fixedFieldKey);
                        targetDataTable.setObject(fixedFieldKey, fixedValue);
                    }
                    recorder.put(fixValuesKey, rowIndex);
                }
                this.resetFixedValues(fixedValues, sourceDataTable);
            }
            block2: for (DimensionItem<IPairItem, S, F> expandRoot : colRootDimensionItems) {
                for (DimensionItem<IPairItem, S, F> item : expandRoot.getAllLeafs()) {
                    boolean canSetValue;
                    if (!this.isMatchedItem(sourceDataTable, item)) continue;
                    String expandFieldKey = item.getPathKey();
                    String sourceFieldKey = item.getSourceField().getKey();
                    Object curTargetValue = targetDataTable.getObject(expandFieldKey);
                    boolean bl = canSetValue = StringUtil.isNumeric((Object)curTargetValue) && TypeConvertor.toInteger((Object)curTargetValue) == 0;
                    if (!(canSetValue |= StringUtil.isBlankOrNull((Object)curTargetValue))) continue block2;
                    targetDataTable.setObject(expandFieldKey, sourceDataTable.getObject(sourceFieldKey));
                    continue block2;
                }
            }
        }
    }

    private boolean isMatchedItem(DataTable dataTable, DimensionItem<IPairItem, S, F> leafItem) {
        Object leafItemValue;
        if (leafItem == null) {
            return true;
        }
        F dimenField = leafItem.getDimensionField();
        if (dimenField == null) {
            return true;
        }
        ColumnInfo columnInfo = dataTable.getMetaData().getColumnInfo(dimenField.getKey());
        Object dimenValue = dataTable.getObject(dimenField.getKey());
        Object itemValue = leafItem.getData().getValue();
        Object object = leafItemValue = itemValue == null ? null : TypeConvertor.toDataType((int)columnInfo.getDataType(), (Object)itemValue);
        if (!this.isEqual(leafItemValue, dimenValue)) {
            return false;
        }
        return this.isMatchedItem(dataTable, leafItem.getParent());
    }

    private DataTable createTargetTableStruct(List<DimensionItem<IPairItem, S, F>> colRootDimensionItems, List<String> fixedFieldKeys, String targetKey, DataTable sourceDataTable) {
        DataTable targetDataTable = new DataTable();
        targetDataTable.setKey(targetKey);
        ColumnInfo tmpColumn = null;
        for (String string : fixedFieldKeys) {
            tmpColumn = sourceDataTable.getMetaData().getColumnInfo(string);
            targetDataTable.addColumn(tmpColumn.deepClone());
        }
        for (DimensionItem dimensionItem : colRootDimensionItems) {
            this.calcTargetTableColumn(dimensionItem, targetDataTable, sourceDataTable);
        }
        return targetDataTable;
    }

    private void calcTargetTableColumn(DimensionItem<IPairItem, S, F> expandRoot, DataTable targetDataTable, DataTable sourceDataTable) {
        S sourceField = expandRoot.getSourceField();
        List<DimensionItem<IPairItem, S, F>> allLeafs = expandRoot.getAllLeafs();
        ColumnInfo expandSourceColumn = sourceDataTable.getMetaData().getColumnInfo(sourceField.getKey());
        for (DimensionItem<IPairItem, S, F> item : allLeafs) {
            String expandKey = item.getPathKey();
            ColumnInfo columnInfo = new ColumnInfo(expandKey, expandSourceColumn.getDataType());
            targetDataTable.addColumn(columnInfo);
        }
    }

    private boolean isFixedValueChanged(HashMap<String, Object> fixedValues, DataTable dataTable) {
        for (Map.Entry<String, Object> entry : fixedValues.entrySet()) {
            Object nextFixedFieldValue;
            String fixedFieldKey = entry.getKey();
            Object curFixedFieldValue = entry.getValue();
            if (this.isEqual(curFixedFieldValue, nextFixedFieldValue = dataTable.getObject(fixedFieldKey))) continue;
            return true;
        }
        return false;
    }

    private void initFixedValues(HashMap<String, Object> fixedValues, List<String> fixedFieldKeys) {
        for (String fixedFieldKey : fixedFieldKeys) {
            fixedValues.put(fixedFieldKey, null);
        }
    }

    private void resetFixedValues(HashMap<String, Object> fixedValues, DataTable sourceDataTable) {
        Object fixedValue = null;
        for (String fixedFieldKey : fixedValues.keySet()) {
            fixedValue = sourceDataTable.getObject(fixedFieldKey);
            fixedValues.put(fixedFieldKey, fixedValue);
        }
    }

    private String getFixValuesKey(List<String> fixedFieldKeys, DataTable dataTable) {
        StringBuilder sb = new StringBuilder();
        Object fixedValue = null;
        for (String fixedFieldKey : fixedFieldKeys) {
            fixedValue = dataTable.getObject(fixedFieldKey);
            sb.append(fixedValue).append("__");
        }
        return sb.toString();
    }

    private boolean isEqual(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }
}

