/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.dict;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yes.struct.dict.ItemTableBase;
import com.bokesoft.yigo.common.i18n.DefaultLocale;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.dict.BaseItem;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Item
implements JSONSerializable,
Serializable {
    private static final long serialVersionUID = -7640509081419239905L;
    private Map<String, ItemTableBase> itemTables = new HashMap<String, ItemTableBase>();
    private long OID;
    private int nodeType;
    private int enable;
    private String itemKey = "";
    private String caption = "";
    private String mainTableKey = "";
    private Map<String, String> i18nCaptions;
    private Map<String, Object> i18nValues;
    private Map<String, List<String>> i18nColumns;
    private String showCode;
    private boolean isInitI18n = false;
    private boolean hasInited = false;

    public Item() {
    }

    public Item(String itemKey, long id) {
        this.itemKey = itemKey;
        this.OID = id;
        if (id == 0L) {
            this.nodeType = 1;
        }
    }

    public Item(JSONObject jsonObj) throws JSONException {
        try {
            this.fromJSON(jsonObj);
        }
        catch (StructException e) {
            e.printStackTrace();
            throw new RuntimeException("Item json \u5e8f\u5217\u5316\u9519\u8bef:" + jsonObj);
        }
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public long getID() {
        return this.OID;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public long getParentID() {
        return TypeConvertor.toLong((Object)this.getValue("ParentID"));
    }

    public int getEnable() {
        return this.enable;
    }

    public ItemTableBase getItemTable(String tableKey) {
        return this.itemTables.get(tableKey);
    }

    public Map<String, ItemTableBase> getItemTables() {
        return this.itemTables;
    }

    public Object getValue(String tableKey, String colKey) {
        ILocale locale;
        List<String> columns;
        if (this.i18nColumns != null && (columns = this.i18nColumns.get(tableKey)) != null && columns.contains(colKey) && (locale = DefaultLocale.getDefaultLocale()) != null) {
            return this.getI18nValue(tableKey, colKey, locale.getLocale());
        }
        ItemTableBase tableBase = this.itemTables.get(tableKey);
        if (tableBase == null) {
            return null;
        }
        return tableBase.getValue(colKey);
    }

    public static void main(String[] args) {
        String a = "zfw.nana";
        int pos = a.indexOf(46);
        String b = a.substring(0, pos);
        String c = a.substring(pos + 1);
    }

    public Object getValue(String colKey) {
        String tableKey = null;
        int pos = colKey.indexOf(46);
        if (pos > 0) {
            tableKey = colKey.substring(0, pos);
            colKey = colKey.substring(pos + 1);
        } else {
            tableKey = this.mainTableKey;
        }
        return this.getValue(tableKey, colKey);
    }

    public Object impl_getValue(String tableKey, String colKey, String locale) {
        return this.getValue(tableKey, colKey);
    }

    @Deprecated
    public Object impl_getValue(String tableKey, String colKey) {
        return this.getValue(tableKey, colKey);
    }

    @Deprecated
    public Object impl_getValue(String colKey) {
        String tableKey = null;
        int pos = colKey.indexOf(46);
        if (pos > 0) {
            tableKey = colKey.substring(0, pos);
            colKey = colKey.substring(pos + 1);
        } else {
            tableKey = this.mainTableKey;
        }
        return this.impl_getValue(tableKey, colKey);
    }

    public String getCaption() {
        if (this.i18nCaptions == null || this.i18nCaptions.isEmpty()) {
            return this.caption;
        }
        ILocale locale = DefaultLocale.getDefaultLocale();
        if (locale == null) {
            return this.caption;
        }
        return this.getCaption(locale.getLocale());
    }

    public void setCaption(String s) {
        this.caption = s;
    }

    public void addI18nCaption(String locale, String caption) {
        if (this.i18nCaptions == null) {
            this.i18nCaptions = new HashMap<String, String>();
        }
        this.i18nCaptions.put(locale, caption);
    }

    public String getCaption(String locale) {
        if (this.i18nCaptions == null || this.i18nCaptions.isEmpty()) {
            return this.caption;
        }
        if (locale == null) {
            return this.caption;
        }
        String s = this.i18nCaptions.getOrDefault(locale, "");
        return s;
    }

    public void setShowCode(String s) {
        this.showCode = s;
    }

    public String getShowCode() {
        return this.showCode;
    }

    public void setInitI18n() {
        this.isInitI18n = true;
    }

    public boolean getIsInitI18n() {
        return this.isInitI18n;
    }

    public void addI18nValue(String tableKey, String colKey, Object value, String locale) {
        if (this.i18nValues == null) {
            this.i18nValues = new HashMap<String, Object>();
        }
        String key = tableKey + "_" + colKey + "_" + locale;
        this.i18nValues.put(key, value);
    }

    public Object getI18nValue(String tableKey, String colKey, String locale) {
        ILocale l;
        if (this.i18nValues == null) {
            return "";
        }
        if (locale == null && (l = DefaultLocale.getDefaultLocale()) != null) {
            locale = l.getLocale();
        }
        String key = tableKey + "_" + colKey + "_" + locale;
        return TypeConvertor.toString((Object)this.i18nValues.get(key));
    }

    public Object getI18nValue(String colKey, String locale) {
        String tableKey = null;
        int pos = colKey.indexOf(46);
        if (pos > 0) {
            tableKey = colKey.substring(0, pos);
            colKey = colKey.substring(pos + 1);
        } else {
            tableKey = this.mainTableKey;
        }
        return this.getI18nValue(tableKey, colKey, locale);
    }

    public void addItemTableBase(ItemTableBase tb, boolean isMainTable) {
        this.itemTables.put(tb.getKey(), tb);
        if (isMainTable) {
            this.mainTableKey = tb.getKey();
            if (this.hasInited) {
                throw new RuntimeException("\u5df2\u7ecf\u521d\u59cb\u5316\u8fc7\uff0c \u4e0d\u5e94\u8be5\u518d\u521d\u59cb\u5316\u6570\u636e\u3002");
            }
            this.initData(tb);
        }
    }

    private void initData(ItemTableBase tb) {
        this.OID = this.OID == 0L ? TypeConvertor.toLong((Object)tb.getValue("OID")) : this.OID;
        this.nodeType = TypeConvertor.toInteger((Object)tb.getValue("NodeType"));
        this.itemKey = tb.getItemKey();
        this.enable = TypeConvertor.toInteger((Object)tb.getValue("Enable"));
        this.hasInited = true;
    }

    public JSONObject toJSON() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("itemKey", (Object)this.getItemKey());
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"oid", (long)this.OID, (long)0L);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"nodeType", (int)this.nodeType, (int)0);
        JSONHelper.writeToJSON((JSONObject)jsonObj, (String)"enable", (int)this.enable, (int)0);
        jsonObj.put("caption", (Object)this.caption);
        jsonObj.put("mainTableKey", (Object)this.mainTableKey);
        jsonObj.put("showCode", (Object)this.showCode);
        if (this.i18nCaptions != null && !this.i18nCaptions.isEmpty()) {
            JSONObject i18ns = new JSONObject();
            for (Map.Entry entry : this.i18nCaptions.entrySet()) {
                i18ns.put((String)entry.getKey(), entry.getValue());
            }
            jsonObj.put("i18nCaption", (Object)i18ns);
        }
        if (this.i18nColumns != null && !this.i18nColumns.isEmpty()) {
            JSONObject i18ncols = new JSONObject(this.i18nColumns);
            jsonObj.put("i18nColumns", (Object)i18ncols);
        }
        if (this.i18nValues != null && !this.i18nValues.isEmpty()) {
            JSONObject i18nV = new JSONObject(this.i18nValues);
            jsonObj.put("i18nValues", (Object)i18nV);
        }
        JSONObject jsonTables = new JSONObject();
        for (String string : this.itemTables.keySet()) {
            if (string.endsWith("_T")) continue;
            ItemTableBase table = this.itemTables.get(string);
            JSONObject itemTableObject = table.toJSON();
            jsonTables.put(string, (Object)itemTableObject);
        }
        jsonObj.put("itemTables", (Object)jsonTables);
        jsonObj.put("isiniti18n", this.isInitI18n);
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
        JSONObject i18ncols;
        JSONObject i18nV;
        this.OID = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"oid", (int)0);
        this.itemKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"itemKey", (String)"");
        this.nodeType = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"nodeType", (int)0);
        this.enable = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"enable", (int)0);
        this.caption = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"caption", (String)"");
        this.mainTableKey = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"mainTableKey", (String)"");
        this.showCode = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"showCode", (String)"");
        JSONObject i18n = jsonObj.optJSONObject("i18nCaption");
        if (i18n != null) {
            for (Object lang : i18n.keySet()) {
                String v = i18n.optString((String)lang);
                if (v == null || v.isEmpty()) continue;
                this.i18nCaptions.put((String)lang, v);
            }
        }
        if ((i18nV = jsonObj.optJSONObject("i18nValues")) != null) {
            for (String k : i18nV.keySet()) {
                String v = i18nV.optString(k);
                if (v == null || v.isEmpty()) continue;
                this.i18nCaptions.put(k, v);
            }
        }
        if ((i18ncols = jsonObj.optJSONObject("i18nColumns")) != null) {
            this.i18nColumns = this.jsonToMapList(i18ncols);
        }
        JSONObject jsonTables = jsonObj.getJSONObject("itemTables");
        this.itemTables.clear();
        Iterator it = jsonTables.keys();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            JSONObject tableObj = jsonTables.getJSONObject(key);
            ItemTableBase table = new ItemTableBase(tableObj);
            this.itemTables.put(table.getKey(), table);
        }
        this.isInitI18n = JSONHelper.readFromJSON((JSONObject)jsonObj, (String)"isiniti18n", (boolean)false);
    }

    private Map<String, List<String>> jsonToMapList(JSONObject jsonObj) {
        HashMap<String, List<String>> outerMap = new HashMap<String, List<String>>();
        Iterator keys = jsonObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONArray innerObj = jsonObj.getJSONArray(key);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < innerObj.length(); ++i) {
                String s = innerObj.getString(i);
                list.add(s);
            }
            outerMap.put(key, list);
        }
        return outerMap;
    }

    public void setI18nColumns(Map<String, List<String>> map) {
        this.i18nColumns = map;
    }

    public String toString() {
        return this.getItemKey() + "_" + this.OID;
    }

    public ItemData toItemData() {
        return new ItemData(this.getItemKey(), this.OID);
    }

    public BaseItem toBaseItem() {
        List<ItemRow> list;
        BaseItem baseItem = new BaseItem(this.getItemKey(), this.OID);
        baseItem.setEnable(this.enable);
        baseItem.setNodeType(this.nodeType);
        baseItem.setShowCode(this.showCode);
        ILocale defaultLocale = DefaultLocale.getDefaultLocale();
        String locale = "";
        if (defaultLocale != null) {
            locale = defaultLocale.getLocale();
        }
        baseItem.setCaption(this.getCaption(locale));
        ItemTableBase mainTableBase = this.itemTables.get(this.mainTableKey);
        if (mainTableBase != null && (list = mainTableBase.getRows()) != null && !list.isEmpty()) {
            List<String> columns = null;
            if (this.i18nColumns != null) {
                columns = this.i18nColumns.get(this.mainTableKey);
            }
            ItemRow row = list.get(0);
            String key = null;
            Object value = null;
            for (Map.Entry<String, Object> entry : row.getEntrySet()) {
                key = entry.getKey();
                value = columns != null && columns.contains(key) ? this.getI18nValue(this.mainTableKey, key, locale) : entry.getValue();
                baseItem.setValue(key, value);
            }
        }
        return baseItem;
    }

    public boolean equals(Item o) {
        if (o == null) {
            return false;
        }
        return this.toString().equalsIgnoreCase(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void writeObject(ObjectOutputStream out) {
        try {
            out.writeUTF(this.itemKey);
            out.writeLong(this.OID);
            out.writeInt(this.nodeType);
            out.writeInt(this.enable);
            out.writeObject(this.itemTables);
            out.writeUTF(this.mainTableKey);
            out.writeUTF(this.caption);
            out.writeUTF(this.showCode);
            out.writeObject(this.i18nCaptions);
            out.writeObject(this.i18nValues);
            out.writeObject(this.i18nColumns);
            out.writeBoolean(this.isInitI18n);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream in) {
        try {
            this.itemKey = in.readUTF();
            this.OID = in.readLong();
            this.nodeType = in.readInt();
            this.enable = in.readInt();
            this.itemTables = (HashMap)in.readObject();
            this.mainTableKey = in.readUTF();
            this.caption = in.readUTF();
            this.showCode = in.readUTF();
            this.i18nCaptions = (Map)in.readObject();
            this.i18nValues = (Map)in.readObject();
            this.i18nColumns = (Map)in.readObject();
            this.isInitI18n = in.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Item clone() {
        Item i = new Item();
        i.itemKey = this.itemKey;
        i.OID = this.OID;
        i.nodeType = this.nodeType;
        i.enable = this.enable;
        i.caption = this.caption;
        HashMap<String, ItemTableBase> map = new HashMap<String, ItemTableBase>();
        for (ItemTableBase itb : this.itemTables.values()) {
            map.put(itb.getKey(), itb.clone());
        }
        i.itemTables = map;
        i.mainTableKey = this.mainTableKey;
        i.showCode = this.showCode;
        if (this.i18nCaptions != null) {
            i.i18nCaptions = new HashMap<String, String>();
            i.i18nCaptions.putAll(this.i18nCaptions);
        }
        if (this.i18nValues != null) {
            i.i18nValues = new HashMap<String, Object>();
            i.i18nValues.putAll(this.i18nValues);
        }
        if (this.i18nColumns != null) {
            i.i18nColumns = new HashMap<String, List<String>>();
            i.i18nColumns.putAll(this.i18nColumns);
        }
        i.isInitI18n = this.isInitI18n;
        return i;
    }
}

