/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.struct.datatable;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.abstractdatatable.IDataTable;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yes.struct.datatable.filter.FilterEval;
import com.bokesoft.yes.struct.datatable.filter.FormulaFilter;
import com.bokesoft.yes.struct.datatable.json.AllDataRowsImpl;
import com.bokesoft.yes.struct.datatype.DataTypeAction;
import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.datatable.ICacheProvider;
import com.bokesoft.yigo.struct.datatable.Indexes;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataTable
implements IDataTable<Row>,
Externalizable,
Comparator<Row>,
JSONSerializable,
IJSONHandler {
    protected ArrayList<Row> viewDataList = new ArrayList();
    private ArrayList<Row> allDataList = new ArrayList();
    private HashMap<Integer, Integer> bookmarkMap = new HashMap();
    protected DataTableMetaData metaData = null;
    private FilterEval filterEval = null;
    private boolean showDeleted = false;
    private int pos = -1;
    private SortCriteria[] vCriteria = null;
    private int bookmarkSeed = 0;
    private String key = "";
    private ICacheProvider cache = null;
    private boolean checkLength = false;
    private Indexes indexes;
    private boolean maintSequence = false;

    public DataTable() {
        this.metaData = new DataTableMetaData();
    }

    public DataTable(DataTableMetaData metaData) {
        this.metaData = metaData;
    }

    public int addColumn(ColumnInfo column) throws StructException {
        this.metaData.addColumn(column);
        int index = this.metaData.getColumnCount() - 1;
        this.doColumnDataChange(index, true);
        if ("Sequence".equals(column.getColumnKey())) {
            this.updateSequenceNumbers(0);
        }
        return index;
    }

    public int addColumn(int columnIndex, ColumnInfo column) throws StructException {
        this.metaData.addColumn(columnIndex, column);
        this.doColumnDataChange(columnIndex, true);
        if ("Sequence".equals(column.getColumnKey())) {
            this.updateSequenceNumbers(0);
        }
        return columnIndex;
    }

    public void removeColumn(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey);
        this.metaData.removeColumn(columnKey);
        this.doColumnDataChange(col, false);
    }

    private final void doColumnDataChange(int index, boolean add) {
    }

    public DataTableMetaData getMetaData() {
        return this.metaData;
    }

    public void setFilter(String sFilter) throws Throwable {
        if (this.filterEval instanceof FormulaFilter) {
            ((FormulaFilter)this.filterEval).setFilter(sFilter);
        } else {
            this.filterEval = new FormulaFilter(sFilter);
        }
    }

    public void setFilterEval(FilterEval filterEval) {
        this.filterEval = filterEval;
    }

    public String getFilter() {
        if (this.filterEval instanceof FormulaFilter) {
            return ((FormulaFilter)this.filterEval).getFilter();
        }
        return null;
    }

    public void filter() throws Throwable {
        if (this.filterEval == null || !this.filterEval.needCheck()) {
            this.viewDataList.clear();
            this.bookmarkMap.clear();
            for (Row r : this.allDataList) {
                if (!this.showDeleted && r.isDeleted()) continue;
                this.viewDataList.add(r);
                this.bookmarkMap.put(r.getBookmark(), this.viewDataList.size() - 1);
            }
        } else {
            this.filterEval.init(this);
            this.viewDataList.clear();
            for (Row r : this.allDataList) {
                if (!this.showDeleted && r.isDeleted()) continue;
                this.viewDataList.add(r);
            }
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            this.beforeFirst();
            while (this.next()) {
                if (this.filterEval.filterCheck(this.getRowByIndex(this.pos))) continue;
                removeList.add(0, this.pos);
            }
            Iterator iterator = removeList.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.viewDataList.remove(index);
            }
            this.bookmarkMap.clear();
            this.beforeFirst();
            while (this.next()) {
                this.bookmarkMap.put(this.getBookmark(), this.pos);
            }
            this.beforeFirst();
        }
        this.updateSequenceNumbers(0);
        this.pos = -1;
    }

    public ArrayList<Integer> filter(String sFilter) throws Throwable {
        if (this.filterEval instanceof FormulaFilter) {
            ((FormulaFilter)this.filterEval).setFilter(sFilter);
        } else {
            this.filterEval = new FormulaFilter(sFilter);
        }
        return this.getfilterRet();
    }

    public ArrayList<Integer> filter(FilterEval filterEval) throws Throwable {
        this.filterEval = filterEval;
        return this.getfilterRet();
    }

    private ArrayList<Integer> getfilterRet() throws Throwable {
        ArrayList<Integer> bkList = new ArrayList<Integer>();
        if (this.filterEval == null || !this.filterEval.needCheck()) {
            for (Row r : this.allDataList) {
                if (!this.showDeleted && r.isDeleted()) continue;
                bkList.add(r.getBookmark());
            }
        } else {
            this.filterEval.init(this);
            for (Row r : this.allDataList) {
                if (!this.showDeleted && r.isDeleted() || !this.filterEval.filterCheck(r)) continue;
                bkList.add(r.getBookmark());
            }
        }
        return bkList;
    }

    public void setSort(String columnKey, boolean ascending) throws StructException {
        this.vCriteria = new SortCriteria[]{new SortCriteria(columnKey, ascending)};
        this.metaData.getColumnInfo(columnKey).getDataTypeAction().sortCheck();
    }

    public void setSort(SortCriteria[] vCriteria) throws StructException {
        this.vCriteria = vCriteria;
        if (vCriteria == null) {
            return;
        }
        for (SortCriteria s : vCriteria) {
            String key = s.getColumnKey();
            this.metaData.getColumnInfo(key).getDataTypeAction().sortCheck();
        }
    }

    public SortCriteria[] getSortCriteria() {
        return this.vCriteria;
    }

    public void clearCriteria() {
        this.vCriteria = null;
    }

    public void sort() throws Throwable {
        this.sort(this);
    }

    public void sort(Comparator<? super Row> comparator) throws Throwable {
        if (this.vCriteria == null || this.vCriteria.length == 0) {
            this.viewDataList.clear();
            this.viewDataList.addAll(this.allDataList);
            this.filter();
        } else {
            Collections.sort(this.allDataList, comparator);
            this.viewDataList.clear();
            this.bookmarkMap.clear();
            for (Row r : this.allDataList) {
                if (!this.showDeleted && r.isDeleted()) continue;
                this.viewDataList.add(r);
                this.bookmarkMap.put(r.getBookmark(), this.viewDataList.size() - 1);
            }
        }
        this.updateSequenceNumbers(0);
        this.pos = -1;
    }

    public void setShowDeleted(boolean showDeleted) throws Throwable {
        if (showDeleted != this.showDeleted) {
            this.showDeleted = showDeleted;
            if (!showDeleted || this.viewDataList.size() != this.allDataList.size()) {
                this.filter();
            }
        }
    }

    @Deprecated
    public void setShowDeletedFlag(boolean showDeleted) {
        this.showDeleted = showDeleted;
    }

    public void clearFilter() throws Throwable {
        this.setFilterEval(null);
        this.filter();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.metaData.writeExternal(out);
        int size = this.viewDataList.size();
        out.writeInt(size);
        for (Row r : this.viewDataList) {
            r.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.metaData = new DataTableMetaData();
        this.metaData.readExternal(in);
        int size = in.readInt();
        for (int i = 1; i <= size; ++i) {
            Row r = new Row(in);
            this.allDataList.add(r);
            this.viewDataList.add(r);
        }
    }

    public DataTable deepClone() {
        DataTable clone = new DataTable();
        clone.setKey(this.key);
        clone.bookmarkSeed = this.bookmarkSeed;
        clone.metaData = this.metaData.deepClone();
        for (Row r : this.viewDataList) {
            Row rc = r.deepClone(clone);
            clone.allDataList.add(rc);
            clone.viewDataList.add(rc);
            clone.bookmarkMap.put(rc.getBookmark(), clone.viewDataList.size() - 1);
        }
        return clone;
    }

    public void setPos(int pos) throws StructException {
        if (pos < -1 || pos > this.viewDataList.size()) {
            throw new StructException(1, "position: " + pos + ", Size: " + this.viewDataList.size());
        }
        this.pos = pos;
    }

    public int getPos() {
        return this.pos;
    }

    public void beforeFirst() {
        this.pos = -1;
    }

    public void afterLast() {
        this.pos = this.viewDataList.size();
    }

    public boolean next() {
        if (this.isAfterLast()) {
            return false;
        }
        ++this.pos;
        return !this.isAfterLast();
    }

    public boolean next(boolean fetch) {
        if (this.cache != null) {
            return this.cache.next(this);
        }
        return this.next();
    }

    public boolean previous() {
        if (this.isBeforeFirst()) {
            return false;
        }
        --this.pos;
        return !this.isBeforeFirst();
    }

    public boolean first() {
        if (this.viewDataList.size() == 0) {
            return false;
        }
        this.pos = 0;
        return true;
    }

    public boolean last() {
        if (this.viewDataList.size() == 0) {
            return false;
        }
        this.pos = this.viewDataList.size() - 1;
        return true;
    }

    @Override
    public int size() {
        return this.viewDataList.size();
    }

    public boolean isEmpty() {
        return this.viewDataList.isEmpty();
    }

    public boolean isBeforeFirst() {
        return this.pos == -1;
    }

    public boolean isAfterLast() {
        return this.pos == this.viewDataList.size();
    }

    public boolean isFirst() {
        return !this.viewDataList.isEmpty() && this.pos == 0;
    }

    public boolean isLast() {
        return !this.viewDataList.isEmpty() && this.pos == this.viewDataList.size() - 1;
    }

    public boolean isLast(boolean fetch) {
        if (this.cache != null) {
            return this.cache.isLast();
        }
        return this.isLast();
    }

    public boolean isValid() {
        return !this.viewDataList.isEmpty() && this.pos >= 0 && this.pos < this.viewDataList.size();
    }

    public Object getOriginalObject(int rowIndex, int columnIndex) {
        return this.viewDataList.get(rowIndex).getOriginalObject(columnIndex);
    }

    public Object getOriginalObject(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getOriginalObject(rowIndex, col);
    }

    public Object getOriginalObject(int columnIndex) {
        return this.getOriginalObject(this.pos, columnIndex);
    }

    public Object getOriginalObject(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getOriginalObject(this.pos, col);
    }

    public Object getObject(int rowIndex, int columnIndex) {
        return this.viewDataList.get(rowIndex).getObject(columnIndex);
    }

    public void setObject(int rowIndex, int columnIndex, Object value) {
        this.checkLength(columnIndex, value);
        this.viewDataList.get(rowIndex).setObject(columnIndex, value);
    }

    public void setInfinity(int rowIndex, int columnIndex) {
        this.viewDataList.get(rowIndex).setObject(columnIndex, "Infinity");
    }

    public void setObject(int rowIndex, int columnIndex, Object value, boolean changeState) {
        this.checkLength(columnIndex, value);
        this.viewDataList.get(rowIndex).setObject(columnIndex, value, changeState);
    }

    public void setCheckLength(boolean checkLength) {
        this.checkLength = checkLength;
    }

    private void checkLength(int columnIndex, Object value) {
        if (!this.checkLength) {
            return;
        }
        if (this.key != null && this.key.endsWith("_NODB")) {
            return;
        }
        ColumnInfo columnInfo = this.metaData.getColumnInfo(columnIndex);
        if (columnInfo.getDataType() == 1002 && value != null) {
            long l2;
            if (!columnInfo.getCheckLength()) {
                return;
            }
            String colKey = columnInfo.getColumnKey();
            if (colKey.endsWith("_NODB") || colKey.endsWith("_NODBItemKey")) {
                return;
            }
            long l1 = columnInfo.getLength();
            if (l1 < (l2 = (long)value.toString().length())) {
                throw new StructException(8, StructException.formatMessage(null, 8, this.getKey(), columnInfo.getColumnKey(), l1, value, l2));
            }
        }
    }

    public Object getObject(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getObject(rowIndex, col);
    }

    public Object impl_getObject(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.impl_findColumnIndexByKey(columnKey, true);
        return this.getObject(rowIndex, col);
    }

    public void setObject(int rowIndex, String columnKey, Object value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setObject(rowIndex, col, value);
    }

    public Object getObject(int columnIndex) {
        return this.getObject(this.pos, columnIndex);
    }

    public void setObject(int columnIndex, Object value) {
        this.setObject(this.pos, columnIndex, value);
    }

    public Object getObject(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getObject(this.pos, col);
    }

    public Object impl_getObject(String columnKey) throws StructException {
        int col = this.metaData.impl_findColumnIndexByKey(columnKey, true);
        return this.getObject(this.pos, col);
    }

    public void setObject(String columnKey, Object value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setObject(this.pos, col, value);
    }

    public void setObject(String columnKey, Object value, boolean changeState) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setObject(this.pos, col, value, changeState);
    }

    public Integer getInt(int rowIndex, int columnIndex) {
        Object o = this.getObject(rowIndex, columnIndex);
        return TypeConvertor.toInteger((Object)o);
    }

    public void setInt(int rowIndex, int columnIndex, Integer value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public Integer getInt(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getInt(rowIndex, col);
    }

    public void setInt(int rowIndex, String columnKey, Integer value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setInt(rowIndex, col, value);
    }

    public Integer getInt(int columnIndex) {
        return this.getInt(this.pos, columnIndex);
    }

    public void setInt(int columnIndex, Integer value) {
        this.setObject(this.pos, columnIndex, (Object)value);
    }

    public Integer getInt(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getInt(this.pos, col);
    }

    public void setInt(String columnKey, Integer value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setInt(this.pos, col, value);
    }

    public String getString(int rowIndex, int columnIndex) {
        return (String)this.getObject(rowIndex, columnIndex);
    }

    public void setString(int rowIndex, int columnIndex, String value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public String getString(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getString(rowIndex, col);
    }

    public void setString(int rowIndex, String columnKey, String value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setString(rowIndex, col, value);
    }

    public String getString(int columnIndex) {
        return this.getString(this.pos, columnIndex);
    }

    public void setString(int columnIndex, String value) {
        this.setObject(this.pos, columnIndex, (Object)value);
    }

    public String getString(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getString(this.pos, col);
    }

    public void setString(String columnKey, String value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setString(this.pos, col, value);
    }

    public Date getDateTime(int rowIndex, int columnIndex) {
        return (Date)this.getObject(rowIndex, columnIndex);
    }

    public void setDateTime(int rowIndex, int columnIndex, Date value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public Date getDateTime(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getDateTime(rowIndex, col);
    }

    public void setDateTime(int rowIndex, String columnKey, Date value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setDateTime(rowIndex, col, value);
    }

    public Date getDateTime(int columnIndex) {
        return this.getDateTime(this.pos, columnIndex);
    }

    public void setDateTime(int columnIndex, Date value) {
        this.setObject(this.pos, columnIndex, (Object)value);
    }

    public Date getDateTime(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getDateTime(this.pos, col);
    }

    public void setDateTime(String columnKey, Date value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setDateTime(this.pos, col, value);
    }

    public BigDecimal getNumeric(int rowIndex, int columnIndex) {
        return TypeConvertor.toBigDecimal((Object)this.getObject(rowIndex, columnIndex));
    }

    public void setNumeric(int rowIndex, int columnIndex, BigDecimal value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public BigDecimal getNumeric(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getNumeric(rowIndex, col);
    }

    public void setNumeric(int rowIndex, String columnKey, BigDecimal value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setNumeric(rowIndex, col, value);
    }

    public BigDecimal getNumeric(int columnIndex) {
        return this.getNumeric(this.pos, columnIndex);
    }

    public void setNumeric(int columnIndex, BigDecimal value) {
        this.setObject(this.pos, columnIndex, (Object)value);
    }

    public BigDecimal getNumeric(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getNumeric(this.pos, col);
    }

    public void setNumeric(String columnKey, BigDecimal value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setNumeric(this.pos, col, value);
    }

    public byte[] getBinary(int rowIndex, int columnIndex) {
        return (byte[])this.getObject(rowIndex, columnIndex);
    }

    public void setBinary(int rowIndex, int columnIndex, byte[] value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public byte[] getBinary(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getBinary(rowIndex, col);
    }

    public void setBinary(int rowIndex, String columnKey, byte[] value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setBinary(rowIndex, col, value);
    }

    public byte[] getBinary(int columnIndex) {
        return this.getBinary(this.pos, columnIndex);
    }

    public void setBinary(int columnIndex, byte[] value) {
        this.setBinary(this.pos, columnIndex, value);
    }

    public byte[] getBinary(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getBinary(this.pos, col);
    }

    public void setBinary(String columnKey, byte[] value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setBinary(this.pos, col, value);
    }

    public Long getLong(int rowIndex, int columnIndex) {
        Object o = this.getObject(rowIndex, columnIndex);
        return TypeConvertor.toLong((Object)o);
    }

    public void setLong(int rowIndex, int columnIndex, Long value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public Long getLong(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getLong(rowIndex, col);
    }

    public void setLong(int rowIndex, String columnKey, Long value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setLong(rowIndex, col, value);
    }

    public Long getLong(int columnIndex) {
        return this.getLong(this.pos, columnIndex);
    }

    public void setLong(int columnIndex, Long value) {
        this.setObject(this.pos, columnIndex, (Object)value);
    }

    public Long getLong(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getLong(this.pos, col);
    }

    public void setLong(String columnKey, Long value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setLong(this.pos, col, value);
    }

    public Boolean getBoolean(int rowIndex, int columnIndex) {
        return TypeConvertor.toBoolean((Object)this.getObject(rowIndex, columnIndex));
    }

    public void setBoolean(int rowIndex, int columnIndex, Boolean value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public Boolean getBoolean(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getBoolean(rowIndex, col);
    }

    public void setBoolean(int rowIndex, String columnKey, Boolean value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setBoolean(rowIndex, col, value);
    }

    public Boolean getBoolean(int columnIndex) {
        return this.getBoolean(this.pos, columnIndex);
    }

    public void setBoolean(int columnIndex, Boolean value) {
        this.setObject(this.pos, columnIndex, (Object)value);
    }

    public Boolean getBoolean(String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        return this.getBoolean(this.pos, col);
    }

    public void setBoolean(String columnKey, Boolean value) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey, true);
        this.setBoolean(this.pos, col, value);
    }

    public int insert(int rowIndex) {
        if (rowIndex < 0) {
            rowIndex = 0;
        } else if (rowIndex > this.viewDataList.size()) {
            rowIndex = this.viewDataList.size();
        }
        this.pos = rowIndex;
        Row r = new Row(this);
        this.allDataList.add(r);
        this.viewDataList.add(rowIndex, r);
        this.updateSequenceNumbers(rowIndex);
        this.bookmarkMap.put(r.getBookmark(), rowIndex);
        if (rowIndex < this.viewDataList.size() - 1) {
            for (int i = rowIndex + 1; i < this.viewDataList.size(); ++i) {
                this.bookmarkMap.put(this.viewDataList.get(i).getBookmark(), i);
            }
        }
        if (this.indexes != null) {
            this.indexes.insertBookmark(r.getBookmark());
        }
        return rowIndex;
    }

    public int insert() {
        return this.insert(this.pos);
    }

    public int append() {
        this.pos = this.viewDataList.size();
        return this.insert();
    }

    public void delete(int rowIndex) {
        Row r = this.viewDataList.get(rowIndex);
        int oldSize = this.viewDataList.size();
        if (r.isNew()) {
            this.allDataList.remove(r);
            this.bookmarkMap.remove(r.getBookmark());
            this.viewDataList.remove(rowIndex);
            if (this.pos > rowIndex) {
                --this.pos;
            }
        } else {
            r.setDeleted();
            if (!this.showDeleted) {
                this.viewDataList.remove(rowIndex);
                this.bookmarkMap.remove(r.getBookmark());
                if (this.pos > rowIndex) {
                    --this.pos;
                }
            }
        }
        this.updateSequenceNumbers(rowIndex);
        int newSize = this.viewDataList.size();
        if (newSize != oldSize && rowIndex < newSize) {
            for (int i = rowIndex; i < newSize; ++i) {
                this.bookmarkMap.put(this.viewDataList.get(i).getBookmark(), i);
            }
        }
        if (this.indexes != null) {
            this.indexes.deleteBookmark(r);
        }
    }

    public void forceRemove(int rowIndex) {
        int newSize;
        Row r = this.viewDataList.get(rowIndex);
        boolean isDeleted = r.isDeleted();
        int oldSize = this.viewDataList.size();
        this.allDataList.remove(r);
        this.bookmarkMap.remove(r.getBookmark());
        this.viewDataList.remove(rowIndex);
        if (this.pos > rowIndex) {
            --this.pos;
        }
        if ((newSize = this.viewDataList.size()) != oldSize && rowIndex < newSize) {
            for (int i = rowIndex; i < newSize; ++i) {
                this.bookmarkMap.put(this.viewDataList.get(i).getBookmark(), i);
            }
        }
        if (!isDeleted && this.indexes != null) {
            this.indexes.deleteBookmark(r);
        }
    }

    public void deleteAll() {
        this.pos = -1;
        this.allDataList.removeAll(this.viewDataList);
        for (Row row : this.viewDataList) {
            if (row.isNew()) continue;
            row.setDeleted();
            this.allDataList.add(row);
        }
        this.viewDataList.clear();
        this.bookmarkMap.clear();
        if (this.showDeleted) {
            this.viewDataList.addAll(this.allDataList);
            for (int i = 0; i < this.viewDataList.size(); ++i) {
                this.bookmarkMap.put(this.viewDataList.get(i).getBookmark(), i);
            }
        }
        if (this.indexes != null) {
            this.indexes.clear();
        }
    }

    public void recoverRow(Row row) throws Throwable {
        if (!row.isDeleted()) {
            throw new RuntimeException("DataTable.recoverRow()\u8c03\u7528\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002");
        }
        row.setState(2);
        this.viewDataList.add(row);
        int rowIndex = this.viewDataList.size() - 1;
        this.bookmarkMap.put(row.getBookmark(), rowIndex);
        if (this.indexes != null) {
            this.indexes.recoverBookmark(row);
        }
    }

    public void batchUpdate() {
        this.batchUpdate(false);
    }

    @Deprecated
    public void clearOriginalData() {
        for (Row r : this.allDataList) {
            r.resetOriginalData();
        }
    }

    @Deprecated
    public void batchUpdate(boolean reserveOrgData) {
        ArrayList<Row> removeList = null;
        for (Row r : this.allDataList) {
            if (r.isDeleted()) {
                if (removeList == null) {
                    removeList = new ArrayList<Row>();
                }
                removeList.add(r);
                continue;
            }
            if (reserveOrgData) {
                r.setState(0);
                continue;
            }
            r.stateUpdate();
        }
        if (removeList != null) {
            this.allDataList.removeAll(removeList);
            this.viewDataList.removeAll(removeList);
            this.bookmarkMap.clear();
            for (int i = 0; i < this.viewDataList.size(); ++i) {
                this.bookmarkMap.put(this.viewDataList.get(i).getBookmark(), i);
            }
            removeList.clear();
        }
        this.pos = this.size() > 0 ? 0 : -1;
    }

    public void delete() {
        this.delete(this.pos);
    }

    public int getState() {
        return this.getState(this.pos);
    }

    public void setState(int state) {
        this.viewDataList.get(this.pos).setState(state);
    }

    public int getState(int rowIndex) {
        return this.viewDataList.get(rowIndex).getState();
    }

    @Override
    public int compare(Row o1, Row o2) {
        for (SortCriteria s : this.vCriteria) {
            int index = 0;
            try {
                index = this.metaData.findColumnIndexByKey(s.getColumnKey());
            }
            catch (StructException e) {
                continue;
            }
            int ret = this.metaData.getColumnInfo(index).getDataTypeAction().compare(o1.getObject(index), o2.getObject(index));
            int n = ret = s.isAscending() ? ret : -ret;
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    public int applyNewBookMark() {
        return this.bookmarkSeed++;
    }

    public int getBookmark() {
        return this.viewDataList.get(this.pos).getBookmark();
    }

    public int getParentBookmark() {
        return this.viewDataList.get(this.pos).getParentBookmark();
    }

    public void setParentBookmark(int bookmark) {
        this.viewDataList.get(this.pos).setParentBookmark(bookmark);
    }

    public int getParentBookmark(int rowIndex) {
        return this.viewDataList.get(rowIndex).getParentBookmark();
    }

    public void setParentBookmark(int rowIndex, int bookmark) {
        this.viewDataList.get(rowIndex).setParentBookmark(bookmark);
    }

    public int getBookmark(int rowIndex) {
        return this.viewDataList.get(rowIndex).getBookmark();
    }

    public int getRowIndexByBookmark(int bkmk) {
        Integer index = this.bookmarkMap.get(bkmk);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public void setBookmark(int bookmark) throws StructException {
        Integer index = this.bookmarkMap.get(bookmark);
        if (index != null) {
            this.pos = index;
            return;
        }
        throw new StructException(1, "bookmark: " + bookmark + ", Size: " + this.viewDataList.size());
    }

    public boolean isBookmarkExist(int bookmark) {
        return this.bookmarkMap.containsKey(bookmark);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key.intern();
    }

    public JSONObject toJSONWithNoData() throws SerializationException, JSONException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("bookmark_seed", this.bookmarkSeed);
        jsonObj.put("key", (Object)this.key);
        jsonObj.put("checkLength", this.checkLength);
        JSONArray columnArray = new JSONArray();
        int size = this.metaData.getColumnCount();
        for (int i = 0; i < size; ++i) {
            ColumnInfo column = this.metaData.getColumnInfo(i);
            columnArray.put((Object)column.toJSON());
        }
        jsonObj.put("columns", (Object)columnArray);
        return jsonObj;
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject jsonObj = this.toJSONWithNoData();
        JSONArray allDataRowArray = new JSONArray();
        int sequenceColumnIndex = this.getMetaData().findColumnIndexByKey("Sequence");
        if (this.filterEval == null || !this.filterEval.needCheck()) {
            Row row;
            int i;
            for (i = 0; i < this.viewDataList.size(); ++i) {
                row = this.viewDataList.get(i);
                if (sequenceColumnIndex >= 0) {
                    row.setObject(sequenceColumnIndex, i + 1, false);
                }
                allDataRowArray.put((Object)row.toJSON());
            }
            if (!this.showDeleted) {
                for (i = 0; i < this.allDataList.size(); ++i) {
                    row = this.allDataList.get(i);
                    if (!row.isDeleted()) continue;
                    allDataRowArray.put((Object)row.toJSON());
                }
            }
        } else {
            for (int i = 0; i < this.allDataList.size(); ++i) {
                Row row = this.allDataList.get(i);
                if (sequenceColumnIndex >= 0) {
                    row.setObject(sequenceColumnIndex, i + 1, false);
                }
                allDataRowArray.put((Object)row.toJSON());
            }
        }
        jsonObj.put("all_data_rows", (Object)allDataRowArray);
        return jsonObj;
    }

    public void fromJSON(JSONObject tableObj) throws SerializationException, JSONException {
        this.filterEval = null;
        this.pos = -1;
        this.showDeleted = false;
        this.vCriteria = null;
        this.metaData.clear();
        this.allDataList.clear();
        this.viewDataList.clear();
        this.bookmarkMap.clear();
        this.bookmarkSeed = tableObj.getInt("bookmark_seed");
        this.key = tableObj.getString("key");
        this.checkLength = tableObj.optBoolean("checkLength", false);
        JSONArray columnArray = tableObj.getJSONArray("columns");
        for (int i = 0; i < columnArray.length(); ++i) {
            JSONObject columnObj = columnArray.getJSONObject(i);
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.fromJSON(columnObj);
            this.metaData.addColumn(columnInfo);
        }
        if (!tableObj.isNull("all_data_rows")) {
            JSONArray allDataRowArray = tableObj.getJSONArray("all_data_rows");
            for (int rowIndex = 0; rowIndex < allDataRowArray.length(); ++rowIndex) {
                JSONObject rowObj = allDataRowArray.getJSONObject(rowIndex);
                Row row = new Row(this, rowObj);
                this.allDataList.add(row);
                if (row.getState() == 3) continue;
                this.viewDataList.add(row);
                this.bookmarkMap.put(row.getBookmark(), this.viewDataList.size() - 1);
            }
        }
        if (this.metaData.constains("Sequence")) {
            Collections.sort(this.allDataList, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    Integer sequence1 = TypeConvertor.toInteger((Object)o1.getObject("Sequence"));
                    Integer sequence2 = TypeConvertor.toInteger((Object)o2.getObject("Sequence"));
                    int result = sequence1.compareTo(sequence2);
                    return result;
                }
            });
            Collections.sort(this.viewDataList, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    Integer sequence1 = TypeConvertor.toInteger((Object)o1.getObject("Sequence"));
                    Integer sequence2 = TypeConvertor.toInteger((Object)o2.getObject("Sequence"));
                    int result = sequence1.compareTo(sequence2);
                    return result;
                }
            });
            this.bookmarkMap.clear();
            for (int index = 0; index < this.viewDataList.size(); ++index) {
                this.bookmarkMap.put(this.viewDataList.get(index).getBookmark(), index);
            }
        }
        this.first();
    }

    public boolean isShowDeleted() {
        return this.showDeleted;
    }

    public int findRow(String columnKey, Object value) {
        int columnIndex = this.metaData.findColumnIndexByKey(columnKey, true);
        int index = -1;
        int size = this.viewDataList.size();
        for (int i = 0; i < size; ++i) {
            Object tmpValue = this.viewDataList.get(i).getObject(columnIndex);
            if (!tmpValue.equals(value)) continue;
            index = i;
            this.setPos(index);
            break;
        }
        return index;
    }

    public int findRow(int columnIndex, Object value) {
        int index = -1;
        int size = this.viewDataList.size();
        for (int i = 0; i < size; ++i) {
            Object tmpValue = this.viewDataList.get(i).getObject(columnIndex);
            if (!tmpValue.equals(value)) continue;
            index = i;
            this.setPos(index);
            break;
        }
        return index;
    }

    public void clear() {
        this.allDataList.clear();
        this.viewDataList.clear();
        this.bookmarkMap.clear();
        this.filterEval = null;
        this.vCriteria = null;
        this.pos = -1;
        if (this.indexes != null) {
            this.indexes.clear();
        }
        this.indexes = null;
    }

    @Override
    @Deprecated
    public Row getRowByIndex(int rowIndex) {
        return this.viewDataList.get(rowIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendString(sb, false);
        return sb.toString();
    }

    public void appendString(StringBuilder sb, boolean enter) {
        if (enter) {
            sb.append("\t");
        }
        sb.append("<Table key=\"");
        sb.append(this.key);
        sb.append("\" showDeleted=\"");
        sb.append(this.showDeleted);
        sb.append("\" filter=\"");
        sb.append(this.filterEval);
        sb.append("\" curRowIndex=\"");
        sb.append(this.pos);
        sb.append("\" vCriteria=\"");
        sb.append(Arrays.toString(this.vCriteria));
        sb.append("\" bookmarkSeed=\"");
        sb.append(this.bookmarkSeed);
        sb.append("\">\n");
        for (Row r : this.viewDataList) {
            sb.append(enter ? "\t\t" : "\t");
            r.appendString(sb);
        }
        if (enter) {
            sb.append("\t");
        }
        sb.append("</Table>\n");
    }

    public DataTable cloneEmpty() throws StructException {
        DataTable newObject = new DataTable();
        newObject.setKey(this.key);
        int columnCount = this.metaData.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            newObject.addColumn(this.metaData.getColumnInfo(i));
        }
        return newObject;
    }

    public void setNew() {
        this.viewDataList.clear();
        this.bookmarkMap.clear();
        this.filterEval = null;
        this.vCriteria = null;
        this.pos = -1;
        this.viewDataList.addAll(this.allDataList);
        for (int i = 0; i < this.allDataList.size(); ++i) {
            Row row = this.allDataList.get(i);
            this.bookmarkMap.put(row.getBookmark(), i);
            row.setState(1);
            row.removeOriginalData();
        }
    }

    public Object[] impl_getRow() {
        return this.viewDataList.get(this.pos).getDataList();
    }

    @Override
    public IJSONHandler newHandler(String token) {
        if ("columns".equals(token)) {
            return this.metaData;
        }
        if ("all_data_rows".equals(token)) {
            return new AllDataRowsImpl(this, this.viewDataList, this.allDataList, this.bookmarkMap);
        }
        return null;
    }

    @Override
    public void putAttr(String name, String value) {
        if ("bookmark_seed".equals(name)) {
            this.bookmarkSeed = Integer.parseInt(value);
        } else if ("key".equals(name)) {
            this.key = value;
        }
    }

    public void impl_SetBookmarkSeed(int value) {
        this.bookmarkSeed = value;
    }

    @Override
    public void endHandler() {
    }

    @Override
    public void endChildHandler(IJSONHandler handler) {
    }

    public void setCache(ICacheProvider cache) {
        this.cache = cache;
    }

    public ICacheProvider getCache() {
        return this.cache;
    }

    public void close() {
        if (this.cache != null) {
            this.cache.close();
        }
    }

    public void updateIndexRowByBookmark(int bookmark) {
        if (this.indexes != null) {
            this.indexes.updateBookmark(bookmark);
        }
    }

    public int fastFindFirst(String[] filterColumns, Object[] filterValues) throws Throwable {
        int[] fastFilterResult = this.fastFilter(filterColumns, filterValues);
        return fastFilterResult == null || fastFilterResult.length == 0 ? -1 : fastFilterResult[0];
    }

    public int[] fastFilter(String[] filterColumns, Object[] filterValues) throws Throwable {
        if (this.indexes == null) {
            this.indexes = new Indexes(this);
        }
        int[] result = this.indexes.getFilterRowIndexes(filterColumns, filterValues);
        return result;
    }

    public int[] fastFilter(String filterColumn, Object filterValue) throws Throwable {
        String[] filterColumns = new String[]{filterColumn};
        Object[] filterValues = new Object[]{filterValue};
        return this.fastFilter(filterColumns, filterValues);
    }

    public Object[][] fastDistinctValues(String[] filterColumns) throws Throwable {
        if (this.indexes == null) {
            this.indexes = new Indexes(this);
        }
        Object[][] result = this.indexes.getDistinctValues(filterColumns);
        return result;
    }

    public int[] fastSort(int[] rowIndexes, final SortCriteria[] vCriteria) throws Throwable {
        final int sortLength = vCriteria.length;
        final int[] sortIndexes = new int[sortLength];
        final DataTypeAction[] dataTypeActions = new DataTypeAction[sortLength];
        for (int i = 0; i < sortLength; ++i) {
            int index;
            sortIndexes[i] = index = this.metaData.findColumnIndexByKey(vCriteria[i].getColumnKey(), true);
            dataTypeActions[i] = this.metaData.getColumnInfo(index).getDataTypeAction();
        }
        List<Integer> rowIndexArray = Arrays.asList(ArrayUtils.toObject((int[])rowIndexes));
        Collections.sort(rowIndexArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                Object[] dataList1 = DataTable.this.viewDataList.get(o1).getDataList();
                Object[] dataList2 = DataTable.this.viewDataList.get(o2).getDataList();
                for (int i = 0; i < sortLength; ++i) {
                    SortCriteria s = vCriteria[i];
                    int index = sortIndexes[i];
                    int ret = dataTypeActions[i].compare(dataList1[index], dataList2[index]);
                    int n = ret = s.isAscending() ? ret : -ret;
                    if (ret == 0) continue;
                    return ret;
                }
                return 0;
            }
        });
        return ArrayUtils.toPrimitive((Integer[])rowIndexArray.toArray(ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY));
    }

    public void deleteRows(int[] rowIndexes) {
        int deleteRowIndexSize;
        int n = deleteRowIndexSize = rowIndexes == null ? 0 : rowIndexes.length;
        if (deleteRowIndexSize == 0) {
            return;
        }
        int viewSize = this.viewDataList.size();
        if (viewSize == deleteRowIndexSize) {
            this.deleteAll();
            return;
        }
        Arrays.sort(rowIndexes);
        for (int i = deleteRowIndexSize - 1; i >= 0; --i) {
            int rowIndex = rowIndexes[i];
            Row r = this.viewDataList.get(rowIndex);
            if (r.isNew()) {
                this.allDataList.remove(r);
                this.bookmarkMap.remove(r.getBookmark());
                this.viewDataList.remove(rowIndex);
            } else {
                r.setDeleted();
                if (!this.showDeleted) {
                    this.viewDataList.remove(rowIndex);
                    this.bookmarkMap.remove(r.getBookmark());
                }
            }
            if (this.indexes == null) continue;
            this.indexes.deleteBookmark(r);
        }
        int minDeleteRowIndex = rowIndexes[0];
        if (this.pos > minDeleteRowIndex) {
            this.pos = minDeleteRowIndex;
        }
        int newSize = this.viewDataList.size();
        for (int i = minDeleteRowIndex; i < newSize; ++i) {
            this.bookmarkMap.put(this.viewDataList.get(i).getBookmark(), i);
        }
    }

    public void setMaintSequence(boolean maintSequence) {
        this.maintSequence = maintSequence;
        this.updateSequenceNumbers(0);
    }

    public boolean isMaintSequence() {
        return this.maintSequence;
    }

    public void updateSequenceNumbers(int rowIndex) {
        if (!this.maintSequence) {
            return;
        }
        Row row = null;
        int seqNum = 0;
        int colIndex = this.metaData.findColumnIndexByKey("Sequence", false);
        if (colIndex > 0) {
            int i;
            for (i = rowIndex - 1; i >= 0; --i) {
                row = this.viewDataList.get(i);
                if (row.getState() == 3) continue;
                seqNum = TypeConvertor.toInteger((Object)row.getObject(colIndex));
                break;
            }
            for (i = rowIndex; i < this.viewDataList.size(); ++i) {
                row = this.viewDataList.get(i);
                if (row.getState() == 3) continue;
                row.setObject(colIndex, ++seqNum);
            }
        }
    }
}

