package com.bokesoft.yigo.struct.usrpara;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.BaseTypeUtil;
import com.bokesoft.yigo.common.def.JavaDataType;

public class Paras {
	private StringHashMap<Para> map = null;

	public Paras() {
	}

	public void put(String key, Object value) {
		if (map == null) {
			map = new StringHashMap<Para>();
		}
		map.put(key, new Para(key, value));
	}

	public Object get(String key) {
		Para p = map != null ? map.get(key) : null;
		return p != null ? p.getValue() : null;
	}

	public Iterator<Entry<String, Para>> iterator() {
		if (map == null) {
			map = new StringHashMap<Para>();
		}
		return this.map.entrySet().iterator();
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject jsonObj = new JSONObject();
		if (map != null) {
			JSONArray items = new JSONArray();
			Iterator<Entry<String, Para>> it = map.entrySet().iterator();
			Entry<String, Para> entry = null;
			while (it.hasNext()) {
				entry = it.next();
				Para p = entry.getValue();
				JSONObject itemObj = new JSONObject();
				itemObj.put("key", entry.getKey());
				
				Object value = p.getValue();
				int type = BaseTypeUtil.getType(p.getValue());
				switch (type) {
				case JavaDataType.USER_DATETIME:
					long date = ((Date)value).getTime();
					itemObj.put("value", date);
					break;
				default:
					itemObj.put("value", value);
					break;
				}
				
				itemObj.put("type", type);
				items.put(itemObj);
			}
			jsonObj.put("items", items);
		}
		return jsonObj;
	}

	public void fromJSON(JSONObject json) throws JSONException {
		JSONArray items = (JSONArray) json.opt("items");
		if (items != null) {
			for (int i = 0, size = items.length(); i < size; ++i) {
				JSONObject itemObj = (JSONObject) items.get(i);
				Para p = new Para();
				p.setKey(itemObj.optString("key"));
				int type = itemObj.optInt("type");
				switch (type) {
				case JavaDataType.USER_INT:
					p.setValue(itemObj.optInt("value"));
					break;
				case JavaDataType.USER_LONG:
					p.setValue(itemObj.optLong("value"));
					break;
				case JavaDataType.USER_STRING:
					p.setValue(itemObj.optString("value"));
					break;
				case JavaDataType.USER_BOOLEAN:
					p.setValue(itemObj.optBoolean("value"));
					break;
				case JavaDataType.USER_DATETIME:
					// TODO:后面再处理，转long型恢复，写json的时候也需要做此处理
					p.setValue(new Date(itemObj.getLong("value")));
					break;
				case JavaDataType.USER_NUMERIC:
					p.setValue(new BigDecimal(itemObj.optString("value")));
					break;
				default:
					//默认 是什么就什么
					p.setValue(itemObj.opt("value"));
					break;
				}
				if (this.map == null) {
					this.map = new StringHashMap<Para>();
				}
				this.map.put(p.getKey(), p);
			}
		}
	}
	public void remove(String key){
		map.remove(key);
	}
}
