package com.bokesoft.yigo.struct.rights;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.struct.exception.StructException;

/**
 * 入口权限
 * 
 * @author zhufw
 *
 */
public class EntryRights implements JSONSerializable {
	private List<String> entryKeys = new ArrayList<String>();

	private boolean hasAllRights = false;

	public EntryRights() {

	}

	/**
	 * 是否有某个入口权限
	 * 
	 * @param entryKey
	 * @return
	 */
	public boolean hasEntryRights(String entryKey) {
		if (hasAllRights) {
			return true;
		}

		return entryKeys.contains(entryKey);
	}
	
	public List<String> getRightsList() {
		return entryKeys;
	}

	/**
	 * 转换为json对象
	 * 
	 * @return json对象
	 */
	public JSONObject toJSON() throws SerializationException, JSONException {
		JSONObject jsonObj = new JSONObject();
		
		if (this.hasAllRights) {
			jsonObj.put(RightsJSONConstants.ENTRYRIGHTS_ALLRIGHTS, true);
		} else {
			jsonObj.put(RightsJSONConstants.ENTRYRIGHTS_ALLRIGHTS, false);
			// 循环put 性能高于 直接构造函数创建
			JSONArray entryKeyArray = new JSONArray();
			for (String entryKey : entryKeys) {
				entryKeyArray.put(entryKey);
			}

			jsonObj.put(RightsJSONConstants.ENTRYRIGHTS_ENTRYKEYS,
					entryKeyArray);
		}
		return jsonObj;

	}

	/**
	 * 从JSON对象获得对应的属性
	 * 
	 * @param jsonObj
	 *            json对象
	 * @throws StructException
	 */
	public void fromJSON(JSONObject jsonObj) throws SerializationException,
			JSONException {
		hasAllRights = jsonObj.getBoolean(RightsJSONConstants.ENTRYRIGHTS_ALLRIGHTS);
		if (!hasAllRights) {
			JSONArray entryKeyArray = jsonObj.getJSONArray(RightsJSONConstants.ENTRYRIGHTS_ENTRYKEYS);
			entryKeys.clear();
			for (int i = 0; i < entryKeyArray.length(); i++) {
				String entryKey = entryKeyArray.getString(i);
				entryKeys.add(entryKey);
			}
		}
	}

	/**
	 * 添加入口权限
	 * 
	 * @param entryKey
	 */
	public void addEntryKey(String entryKey) {
		if (hasAllRights) {
			return;
		}
		if(entryKey.equalsIgnoreCase("*")){
			hasAllRights = true;
		}else if (!entryKeys.contains(entryKey)) {
				entryKeys.add(entryKey);
		}
	}

	/**
	 * 设置是否有所有入口权限
	 * 
	 * @param b
	 */
	public void setAllRights(boolean b) {
		hasAllRights = b;
	}

	/**
	 * 是否有所有入口权限
	 * 
	 * @return
	 */
	public boolean hasAllRights() {
		return this.hasAllRights;
	}

	public void merge(EntryRights er) {
		if(er == null){
			return;
		}
		
		//自身有所有权限　，　则不合并
		if(hasAllRights){
			return;
		}
		
		if(er.hasAllRights()){
			this.hasAllRights = true;
			return;
		}
		
		this.entryKeys.removeAll(er.getRightsList());
		this.entryKeys.addAll(er.getRightsList());	
	}

}
