package com.bokesoft.yigo.struct.expand;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.common.struct.PairItem;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;

/**
 * 生成扩展维度项
 * 
 * @author chenbb
 *
 * @param <S> 扩展原数据字段
 * @param <F> 扩展维度字段
 */
public abstract class AbstractDimensionsCreator<S extends IExpandSourceField<F>, F extends IExpandDimensionField> {
	/**
	 * 扩展定义 
	 * @param expandDefine
	 * @return
	 * @throws Throwable
	 */
	public List<DimensionItem<IPairItem, S, F>> createDimensions(IExpandTableDefine<S, F> tableDefine) throws Throwable {
		ArrayList<DimensionItem<IPairItem, S, F>> rootDimensionItems = new ArrayList<>();
		List<S> expandFields = tableDefine.getExpandFields();
		if (expandFields != null) {
			for (S expandField : expandFields) {
				DimensionItem<IPairItem, S, F> rootDimensionItem = createDimensionRootItem(expandField, tableDefine);
				rootDimensionItems.add(rootDimensionItem);
			}
		}
		return rootDimensionItems;
	}
	
	/**
	 * 创建某扩展字段的维度根
	 * @param expandField
	 * @return
	 * @throws Throwable 
	 */
	private DimensionItem<IPairItem, S, F> createDimensionRootItem(S expandField, IExpandTableDefine<S, F> tableDefine) throws Throwable {
		// 创建扩展根
		PairItem item = new PairItem(expandField.getKey(), expandField.getKey());
		DimensionItem<IPairItem, S, F> root = new DimensionItem<>(item, null, expandField);
		ArrayList<DimensionItem<IPairItem, S, F>> parentLevelDimensionItems = new ArrayList<>();
		parentLevelDimensionItems.add(root);
		
		// 创建扩展维度层
		F dimensionField = null;
		for (String dimensionFieldKey : expandField.getDimensionFieldKeys()) {
			dimensionField = tableDefine.getDimensionField(dimensionFieldKey);
			ArrayList<DimensionItem<IPairItem, S, F>> curLevelDimensionItems = new ArrayList<>();
			List<IPairItem> dimensionValues = getDimensionValues(dimensionField);
			for (IPairItem dimensionValue : dimensionValues) {
				for (DimensionItem<IPairItem, S, F> parentLevelDimensionItem : parentLevelDimensionItems) {
					DimensionItem<IPairItem, S, F> dimensionItem = new DimensionItem<>(dimensionValue, dimensionField, expandField);
					parentLevelDimensionItem.addChild(dimensionItem);
					curLevelDimensionItems.add(dimensionItem);
				}
			}
			parentLevelDimensionItems = curLevelDimensionItems;
		}
		return root; 
	}
	
	public static List<IPairItem> parseToListItems(String content) {
		ArrayList<IPairItem> items = new ArrayList<>();
		String s = (String) content;
		String[] v = s.split(";");
		int length = v.length;
		for (int j = 0; j < length; ++j) {
			String tmp = v[j];
			int commaPos = tmp.indexOf(',');
			String value = tmp.substring(0, commaPos);
			String caption = tmp.substring(commaPos + 1);
			items.add(new PairItem(value, caption));
		}
		return items;
	}
	
	public static List<IPairItem> parseToListItems(DataTable table) {
		ArrayList<IPairItem> items = new ArrayList<>();
		table.beforeFirst();
		while (table.next()) {
			Object value = table.getObject(0);
			Object objCaption = table.getObject(1);
			String caption = objCaption == null ? "" : objCaption.toString();
			items.add(new PairItem(value, caption));
		}
		return items;
	}
	
	/**
	 * 根据维度字段, 获取维度扩展结果项
	 * @param dimensionField 维度字段
	 * @return
	 */
	protected abstract List<IPairItem> getDimensionValues(F dimensionField) throws Throwable;
}
