package com.bokesoft.yigo.struct.document;

import java.util.HashSet;

/**
 * 对表格保存做的过滤
 * 
 * @author 刘翔翔
 *
 */
public class TableSaveFilterDetail {

	/** 保存 */
	public static final int save = 1;
	/** 不保存 */
	public static final int noSave = 2;
	/** 只保存指定的列（系统字段会默认保存） */
	public static final int saveSpecifiedFieldOnly = 3;
	/** 不保存指定的列（不能设置为系统字段） */
	public static final int noSaveSpecifiedField = 4;

	/** 是否保存这张表的数据 */
	private int saveType = save;
	/** 字段KEY的队列 */
	private HashSet<String> fieldKeySet = new HashSet<String>();

	public HashSet<String> getFieldKeySet() {
		return fieldKeySet;
	}

	TableSaveFilterDetail() {
	}

	public int getSaveType() {
		return saveType;
	}

	public void setSaveType(int saveType) {
		this.saveType = saveType;
	}

	public void addFieldKey(String fieldKey) {
		fieldKeySet.add(fieldKey);
	}

}
