package com.bokesoft.yigo.struct.document;

import java.util.Collection;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.meta.dataobject.MetaOIDFilter;

/**
 * 一个简单对象，用以描述一个Document的每一个Table的Filter以及OID条件
 * 
 * @author 刘翔翔
 * 
 */
public class FilterMap extends StringHashMap<TableFilterDetail> implements JSONSerializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 数据查询的类型，取值范围见{@link com.bokesoft.yigo.struct.document.DocumentType}
	 */
	private int type = DocumentType.DATAOBJECT;
	/** 数据对象标识 */
	private long OID = -1;
	/** 是否载入文档的信息 */
	private boolean needDocInfo = true;
	/** 设置是否使用游标，设置该属性时，对Document中表的遍历不能使用next()，必须使用next(true) */
	private boolean useCursor = false;
	/** 是否中间层加载*/
	private boolean loadInMid = true;

	// 并非序列化范围的内容
	/** Form中的 OID的过滤条件 */
	private MetaOIDFilter OIDFilter = null;

	public FilterMap() {
	}

	public void setStartRow(String tableKey, int row) {
		getTableFilterNotNull(tableKey).setStartRow(row);
	}

	public void setMaxRows(String tableKey, int max) {
		getTableFilterNotNull(tableKey).setMaxRows(max);
	}

	public TableFilterDetail getTableFilterNotNull(String key) {
		TableFilterDetail t = get(key);
		if (t == null) {
			t = new TableFilterDetail(key);
			put(key, t);
		}
		return t;
	}

	public void setIgnoreLoad(String tableKey, boolean b){
		getTableFilterNotNull(tableKey).setIgnoreLoad(b);
	}
	
	
	public TableFilterDetail getTableFilter(String key) {
		return get(key);
	}

	public void putFieldValueCondition(String key, String fieldKey, Object value) {
		getTableFilterNotNull(key).addFieldValueCondition(fieldKey, value);
	}

	public void appendFilterParaValue(String key, Object value) {
		getTableFilterNotNull(key).appendParaValue(value);
	}

	public void removeFieldValueCondition(String key, String fieldKey) {
		TableFilterDetail t = get(key);
		if (t != null)
			t.removeFieldValueCondition(fieldKey);
	}

	public void clearFieldValueCondition(String key) {
		TableFilterDetail t = get(key);
		if (t != null)
			t.clearFieldValueCondition();
	}

	public void clearAllFieldValueCondition() {
		for (TableFilterDetail t : values())
			t.clearFieldValueCondition();
	}
	
	public void reset() {
		Collection<TableFilterDetail> fds = this.values();
		for( TableFilterDetail fd : fds ) {
			fd.setStartRow(0);
		}
	}

	/**
	 * 设置对象标识
	 * 
	 * @param OID
	 *            对象标识
	 */
	public void setOID(long OID) {
		this.OID = OID;
	}

	/**
	 * 取得对象标识
	 * 
	 * @return 对象标识
	 */
	public long getOID() {
		return this.OID;
	}

	/**
	 * 设置数据查询的类型
	 * 
	 * @param type
	 *            类型
	 * @see com.bokesoft.yigo.struct.document.DocumentType
	 */
	public void setType(int type) {
		this.type = type;
	}

	/**
	 * 取得数据查询的类型
	 * 
	 * @see com.bokesoft.yigo.struct.document.DocumentType
	 * @return 数据查询的类型
	 */
	public int getType() {
		return this.type;
	}

	/**
	 * 设置是否载入文档信息
	 * 
	 * @param b
	 *            标志
	 */
	public void setNeedDocInfo(boolean b) {
		this.needDocInfo = b;
	}

	/**
	 * 取得是否载入文档信息
	 * 
	 * @return 标志
	 */
	public boolean isNeedDocInfo() {
		return this.needDocInfo;
	}
	
	/**
	 * 取得是否在中间层使用
	 * 
	 * @return 标志
	 */
	public boolean isLoadInMid() {
		return loadInMid;
	}

	/**
	 * 设置是否在中间层使用 
	 * 
	 * @param loadInMid 标志
	 */
	public void setLoadInMid(boolean loadInMid) {
		this.loadInMid = loadInMid;
	}

	public JSONObject toJSON() throws SerializationException, JSONException {
		JSONObject jsonObj = new JSONObject();
		jsonObj.put("type", type);
		jsonObj.put("OID", OID);
		jsonObj.put("needDocInfo", needDocInfo);

		JSONArray filterMapArray = new JSONArray();
		for (TableFilterDetail tableFilterDetail : values())
			filterMapArray.put(tableFilterDetail.toJSON());
		jsonObj.put("filterMap", filterMapArray);

		return jsonObj;
	}

	public void fromJSON(JSONObject jsonObj) throws SerializationException, JSONException {
		clear();
		type = jsonObj.getInt("type");
		OID = jsonObj.getLong("OID");
		needDocInfo = jsonObj.getBoolean("needDocInfo");

		JSONArray filterMapArray = jsonObj.getJSONArray("filterMap");
		for (int i = 0; i < filterMapArray.length(); i++) {
			JSONObject filterObj = filterMapArray.getJSONObject(i);
			TableFilterDetail tableFilter = new TableFilterDetail();
			tableFilter.fromJSON(filterObj);
			put(tableFilter.getTableKey(), tableFilter);
		}
	}

	public MetaOIDFilter getOIDFilter() {
		return OIDFilter;
	}

	public void setOIDFilter(MetaOIDFilter oIDFilter) {
		OIDFilter = oIDFilter;
	}

	/**
	 * 设置是否使用游标
	 * @param useCursor 标志
	 */
	public void setUseCursor(boolean useCursor) {
		this.useCursor = useCursor;
	}
	
	/**
	 * 取得是否使用游标标志
	 * @return 标志
	 */
	public boolean isUseCursor() {
		return this.useCursor;
	}
	
	@Override
	public Object clone() {
		FilterMap newObject = new FilterMap();
		for(Entry<String, TableFilterDetail> entry : this.entrySet()){
			newObject.put(entry.getKey(), (TableFilterDetail) entry.getValue().clone());
		}
		newObject.setType(type);
		newObject.setOID(OID);
		newObject.setNeedDocInfo(needDocInfo);
		newObject.setUseCursor(useCursor);
		newObject.setLoadInMid(loadInMid);
		newObject.setOIDFilter(OIDFilter == null ? null : (MetaOIDFilter)OIDFilter.clone());
		return newObject;
	}
}

