package com.bokesoft.yigo.struct.dict;

import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.dict.DictJSONConstants;
import com.bokesoft.yigo.common.json.JSONSerializable;

/**
 * 封装字典的oid 与 itemKey 
 * @author zhufw
 *
 */
public class ItemData implements JSONSerializable{
	private String itemKey;
	private String editValue;//字典isEditValue为true是，值用editValue存储
	private long oid;
	
	public ItemData(JSONObject jsonObj){
		try {
			fromJSON(jsonObj);
		} catch (Throwable e) {
			throw new SerializationException(SerializationException.JSON_DATA_ERROR ,"ItemData json 序列化错误:"+jsonObj);
		}
	}
	
	public ItemData(String itemKey , long id){
		if(itemKey == null || itemKey.length() == 0){
			throw new RuntimeException("创建字典节点对象错误， itemKey=["+itemKey+"] , oid =["+id+"]");
		}
		
//		this.itemKey = itemKey.toLowerCase();
		this.itemKey = itemKey;
		this.oid = id;
	}
	public ItemData(String itemKey , long id,String editValue){
		if(itemKey == null || itemKey.length() == 0){
			throw new RuntimeException("创建字典节点对象错误， itemKey=["+itemKey+"] , oid =["+id+"]");
		}

//		this.itemKey = itemKey.toLowerCase();
		this.itemKey = itemKey;
		this.oid = id;
		this.editValue = editValue;
	}
	
	public String getItemKey(){
		return this.itemKey;
	}
	
	public Long getOID(){
		return this.oid;
	}

	public String getEditValue() {
		return editValue;
	}

	public String toString(){
		return this.itemKey+"_"+this.oid;
	}
	
	public boolean equals(Object o){
		if(o == null){
			return false;
		}
		return toString().equals(o.toString());
	}
	
	@Override
	public int hashCode() {
		return toString().hashCode();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException,JSONException {
		JSONObject jsonObj = new JSONObject();
		jsonObj.put(DictJSONConstants.ITEMDATA_ITEMKEY, getItemKey());
		jsonObj.put(DictJSONConstants.ITEMDATA_OID, oid);
		jsonObj.put(DictJSONConstants.ITEMDATA_EDIT_VALUE, editValue);
		return jsonObj;
	}
	
	@Override
	public void fromJSON(JSONObject jsonObj) throws SerializationException,JSONException {
		oid = JSONHelper.readFromJSON(jsonObj, DictJSONConstants.ITEMDATA_OID, 0l);
		itemKey = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEMDATA_ITEMKEY,"");
		editValue = JSONHelper.readFromJSON(jsonObj,DictJSONConstants.ITEMDATA_EDIT_VALUE,"");
	}
	
}
